/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import au.com.ordermate.reports.PrintDataReport;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.Image;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;

public class HeaderSubReport
extends PrintDataReport {
    public static final String FILE_NAME = "/ordermate/reports/printing/PrintHeaderSubreport.jrxml";

    public HeaderSubReport() {
        super(FILE_NAME, "Header Sub Report Path");
        Image logo;
        BusinessInfo info = BusinessInfo.getInstance();
        this.addReportParam("companyName", info.getName());
        this.addReportParam("abn", info.getAbn());
        this.addReportParam("address", info.getAddressString() != null ? info.getAddressString() : "");
        if (info.getPhone() != null && !info.getPhone().equalsIgnoreCase("")) {
            this.addReportParam("phone", info.getPhone());
        }
        if ((logo = this.getLogo()) != null) {
            this.addReportParam("logo", logo);
        }
    }

    public Image getLogo() {
        BusinessInfo info = BusinessInfo.getInstance();
        String logoPath = info.getLogo();
        if (StringUtils.isEmpty(logoPath)) {
            return null;
        }
        try {
            Image image = IconLoader.getImage(logoPath);
            image = (Image)((Object)new ImageHelper().removeAlpha(image, Color.WHITE));
            return image;
        }
        catch (IconLoader.IconNotFoundException e) {
            OrderMate.LOG.warn("Could not find icon : " + logoPath, (Throwable)e);
            return null;
        }
    }

    public Map<String, ?> getParamsMap() {
        return super.getReportParams();
    }
}

