/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import au.com.ordermate.reports.PrintDataReport;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.CustomerDebtorInterface;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.SystemProperty;
import ordermate.database.print.FinanceTransactionPrintData;
import ordermate.database.print.ItemPrintData;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.printSummary.collecting.CollectionStrategy;
import ordermate.internationalization.Internationalization;
import ordermate.reports.printing.HeaderSubReport;
import ordermate.reports.printing.TransactionsSubReport;

public class InvoiceReport
extends PrintDataReport {
    private static final String KEY_INVOICE_NO = "invoiceNo";
    private static final String KEY_DATE = "date";
    private static final String KEY_TIME = "time";
    private static final String KEY_CUSTOMER = "customer";
    private static final String KEY_TABLE = "table";
    private static final String KEY_NUMBER_OF_PAX = "pax";
    private static final String KEY_PHONE = "secondaryPhone";
    private static final String KEY_SURCHAGES = "surcharges";
    private static final String KEY_DISCOUNTS = "discounts";
    private static final String KEY_TRANSACTIONS = "transactions";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_TOTAL_TAX = "total tax";
    private static final String KEY_TAX_LABEL = "tax label";
    private static final String KEY_DOLLAR_SIGN = "dollarSign";
    private static final String KEY_DUE = "due";
    private static final String KEY_DUE_DATE = "due date";
    private static final String KEY_TERMS = "paymentTerms";
    private static final String KEY_PAYMENT_DETAILS = "paymentDetails";
    private static final String KEY_INVOICE_NOTE = "invoiceNote";
    private static final String KEY_GROUPING_BY_CATEGORY = "groupingByCategory";
    public static final String DEFAULT_TEMPLATE_PATH = "/ordermate/reports/printing/InvoiceReportA4.jrxml";
    public static final String DEFAULT_TEMPLATE_CONFIG_PATH = "Invoice Report A4 Path";
    public static final String DEFAULT_LARGE_TEMPLATE_PATH = "/ordermate/reports/printing/InvoiceReportA4Large.jrxml";
    public static final String DEFAULT_LARGE_TEMPLATE_CONFIG_PATH = "Invoice Report A4 Large Path";
    public static final String DEFAULT_A5_TEMPLATE_PATH = "/ordermate/reports/printing/InvoiceReportA5.jrxml";
    public static final String DEFAULT_FINE_DINE_PATH = "/ordermate/reports/printing/InvoiceReportA4FineDine.jrxml";
    public static final String DEFAULT_FINE_DINE_PATH_CONDITIONAL = "/ordermate/reports/printing/InvoiceReportA4FineDineConditional.jrxml";
    public static final String DEFAULT_FINE_DINE_PATH_PAYMENT_DETAIL = "/ordermate/reports/printing/InvoiceReportA4FineDineTransactions.jrxml";
    public static final String DEFAULT_FINE_DINE_PATH_TEST = "/ordermate/reports/printing/InvoiceReportA4FineDineConditional.jrxml";
    public static final String JRXML_HACK_FILE_FINE_DINE_CONDITIONAL = "InvoiceReportA4FineDineConditional.jrxml";
    public static final String JRXML_HACK_FILE_FINE_DINE = "InvoiceReportA4FineDine.jrxml";
    private boolean isHackForSubreportDynamicWidthActive = false;

    public InvoiceReport(String reportFile, String property) {
        super(reportFile, property);
        this.addReportParam(KEY_DOLLAR_SIGN, Internationalization.getLiteralFor("DOLLAR_SIGN"));
        this.addSubReport(new HeaderSubReport());
        TransactionsSubReport transactionReport = new TransactionsSubReport();
        this.addSubReport(transactionReport);
        if (reportFile.endsWith(JRXML_HACK_FILE_FINE_DINE) || reportFile.endsWith(JRXML_HACK_FILE_FINE_DINE_CONDITIONAL)) {
            this.setupHackForSmallTransactionSummary(reportFile, transactionReport);
        }
    }

    public InvoiceReport(ItemGroup account, String reportFile, String property) {
        this(reportFile, property);
        this.setAccount(account);
    }

    public void setAccount(ItemGroup account) {
        List<ItemPrintData> itemPrintData;
        if (SystemProperty.getInstance().getReceiptGrouping().equals((Object)CollectionStrategy.Category)) {
            this.addReportParam(KEY_GROUPING_BY_CATEGORY, Boolean.TRUE);
            itemPrintData = ItemPrintData.getItemPrintDataGroupedByCategory(account.getItems());
        } else {
            this.addReportParam(KEY_GROUPING_BY_CATEGORY, Boolean.FALSE);
            itemPrintData = ItemPrintData.getItemPrintData(account.getItems());
        }
        if (itemPrintData.size() == 0 && account.getFinanceTransactions().size() > 0) {
            itemPrintData.add(ItemPrintData.getDummyItemPrintData());
        }
        this.setPrintData(itemPrintData);
        String invoiceNo = "#" + account.getID();
        this.addReportParam(KEY_INVOICE_NO, invoiceNo);
        Date date = new Date();
        if (account instanceof Account) {
            date = ((Account)account).getCreationDateTime();
        }
        this.addReportParam(KEY_DATE, date);
        this.addReportParam(KEY_TIME, date);
        if (account instanceof TableAccount) {
            this.addReportParam(KEY_TABLE, ((TableAccount)account).getLabel());
            this.addReportParam(KEY_NUMBER_OF_PAX, ((TableAccount)account).getNumPatrons() > 0 ? String.valueOf(((TableAccount)account).getNumPatrons()) : "");
        }
        String discounts = account.getPriceAdjHelper().stringifyDiscountSummary();
        this.addReportParam(KEY_DISCOUNTS, discounts);
        String surcharges = account.getPriceAdjHelper().stringifySurchargeSummary();
        this.addReportParam(KEY_SURCHAGES, surcharges);
        double total = account.getTotal().doubleValue();
        this.addReportParam(KEY_TOTAL, new Double(total));
        double totalTax = account.getTax().doubleValue();
        this.addReportParam(KEY_TOTAL_TAX, new Double(totalTax));
        this.addReportParam(KEY_TAX_LABEL, SystemProperty.getInstance().getBaseTaxLabel());
        if (account.getCustomer() != null) {
            String customer = account.getCustomer().getName();
            this.addReportParam(KEY_CUSTOMER, customer);
            String phone = account.getCustomer().getPhoneNumber();
            this.addReportParam(KEY_PHONE, phone);
        }
        this.addReportParam(KEY_DUE_DATE, null);
        if (account.getAccount() != null && account.getAccount().isDebtorSale()) {
            this.setupDebtorInvoice(account.getAccount().getUniqueDebtorSale());
        } else if (account.getAccount() != null) {
            if (account.getItemHelper().getUnpaidItems().isEmpty()) {
                this.setupSmallPaymentSummary(account.getAccount());
            } else {
                this.setupRegularInvoice(account.getAccount());
            }
        }
        this.addReportParam(KEY_PAYMENT_DETAILS, SystemProperty.getInstance().getInvoicePaymentDetail());
    }

    private void setupDebtorInvoice(DebtorSale debtorSale) {
        double due = debtorSale.getAmountOutstanding().doubleValue();
        List<FinanceTransactionPrintData> transactionSummary = FinanceTransactionPrintData.getFinanceTransactionPrintData(debtorSale);
        transactionSummary.addAll(FinanceTransactionPrintData.getFinanceTransactionPrintData(debtorSale.getSaleAccount().getFinanceTransactions()));
        this.addReportParam(KEY_TRANSACTIONS, new JRBeanCollectionDataSource(transactionSummary));
        AbstractDebtor debtor = debtorSale.getDebtor();
        if (debtor.hasTerms()) {
            this.addReportParam(KEY_DUE_DATE, debtorSale.getDueDate());
            this.addReportParam(KEY_TERMS, debtor.getTermsValue().toString());
        }
        if (debtorSale.getInvoiceNote() != null && !debtorSale.getInvoiceNote().isEmpty()) {
            this.addReportParam(KEY_INVOICE_NOTE, debtorSale.getInvoiceNote());
        }
        String customer = debtor.getLabel();
        if (debtor instanceof CustomerDebtorInterface) {
            customer = CustomerDebtorInterface.Helper.getPrintString((CustomerDebtorInterface)((Object)debtor));
        }
        this.addReportParam(KEY_CUSTOMER, customer);
        this.addReportParam(KEY_DUE, new Double(due));
    }

    private void setupRegularInvoice(Account account) {
        this.addReportParam(KEY_DUE, new Double(account.getDue().doubleValue()));
        List<FinanceTransactionPrintData> transactionSummary = FinanceTransactionPrintData.getFinanceTransactionPrintData(account.getFinanceTransactions());
        this.addReportParam(KEY_TRANSACTIONS, new JRBeanCollectionDataSource(transactionSummary));
    }

    private void setupHackForSmallTransactionSummary(String reportFile, TransactionsSubReport subReportToRemove) {
        if (subReportToRemove != null && this.getSubReports().contains(subReportToRemove)) {
            this.getSubReports().remove(subReportToRemove);
        }
        PrintDataReport transactionsReportSmall = new PrintDataReport(DEFAULT_FINE_DINE_PATH_PAYMENT_DETAIL, "Invoice Report A4 Fine Dine Transactions Path"){};
        this.addSubReport(transactionsReportSmall);
        this.isHackForSubreportDynamicWidthActive = true;
    }

    private void setupSmallPaymentSummary(Account account) {
        List<FinanceTransactionPrintData> transactionSummary = FinanceTransactionPrintData.getFinanceTransactionPrintData(account.getFinanceTransactions());
        this.addReportParam(KEY_TRANSACTIONS, new JRBeanCollectionDataSource(transactionSummary));
    }
}

