/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;
import ordermate.OrderMate;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;

    public static void printComponent(Component c) throws PrinterException {
        new PrintUtilities(c).print();
    }

    public PrintUtilities(Component theComponentToBePrinted) {
        this.componentToBePrinted = theComponentToBePrinted;
    }

    public void print() throws PrinterException {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            OrderMate.LOG.debug("Calling PrintJob.print()");
            printJob.print();
            OrderMate.LOG.debug("End PrintJob.print()");
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        int response = 1;
        Graphics2D g2 = (Graphics2D)g;
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        Dimension d = this.componentToBePrinted.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            response = 1;
        } else {
            g2.translate(pf.getImageableX(), pf.getImageableY());
            g2.translate(0.0, (double)(-pageIndex) * pageHeight);
            g2.scale(scale, scale);
            this.componentToBePrinted.paint(g2);
            PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
            response = 0;
        }
        return response;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

