/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorsSummary;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.SystemProperty;
import ordermate.database.print.DebtorStatementLinePrintData;
import ordermate.internationalization.Internationalization;
import ordermate.reports.printing.DebtorStatementReport;
import ordermate.reports.printing.HeaderSubReport;

public class StatementReport
extends DebtorStatementReport {
    public static final String DEFAULT_JRXML_FILENAME = "StatementPrintDataReport.jrxml";

    public StatementReport(String newFileName) {
        super(newFileName, "Statement Print Data Report Path");
    }

    public StatementReport(List debtorSales, Price openingBalance, String newFileName) {
        this(newFileName);
        this.addSubReport(new HeaderSubReport());
        this.setDebtorSales(debtorSales, openingBalance);
    }

    public final void setDebtorSales(List debtorSales, Price openingBalance) {
        AbstractDebtor debtor;
        Price taxSum = Price.ZERO;
        DebtorSale sale = (DebtorSale)debtorSales.get(0);
        if (debtorSales.size() > 0) {
            sale = (DebtorSale)debtorSales.get(0);
            debtor = sale.getDebtor();
            this.setupHeader(debtor);
            for (int i = 0; i < debtorSales.size(); ++i) {
                DebtorSale saleTemp = (DebtorSale)debtorSales.get(i);
                taxSum = saleTemp.calculateTAX(saleTemp.getTotal()).add(taxSum);
            }
        } else {
            throw new IllegalArgumentException("No debtor sales in list");
        }
        DebtorsSummary summary = DebtorsSummary.summarize(debtor);
        this.addReportParam("paymentTerms", debtor.getTermsValue().toString());
        this.addReportParam("summaryCurrent", new Double(summary.getCurrent().doubleValue()));
        this.addReportParam("summaryThirtyDays", new Double(summary.getThirtyDays().doubleValue()));
        this.addReportParam("summarySixtyDays", new Double(summary.getSixtyDays().doubleValue()));
        this.addReportParam("summarySixtyPlusDays", new Double(summary.getSixtyPlusDays().doubleValue()));
        this.addReportParam("summaryAmountDue", new Double(summary.getOutstanding().doubleValue()));
        this.addReportParam("paymentDetails", SystemProperty.getInstance().getInvoicePaymentDetail());
        this.addReportParam("dollarSign", Internationalization.getLiteralFor("DOLLAR_SIGN"));
        this.addReportParam("summaryAmountTax", taxSum.doubleValue());
        List statementPrintData = DebtorStatementLinePrintData.getDebtorStatementLinePrintData(debtorSales, openingBalance);
        this.setPrintData(statementPrintData);
    }
}

