/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.printing;

import au.com.ordermate.reports.AbstractReport;
import au.com.ordermate.reports.ReportLoader;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesMod;
import ordermate.database.sales.SalesOption;

public class TicketPrepReport
extends AbstractReport {
    private static final String ITEM_DESC = "itemDesc";
    private static final String ITEM_PRICE = "itemPrice";
    private static final String ITEM_ID = "itemID";
    private static final String ITEM_SIZE = "itemSize";
    private static final String ITEM_NOTES = "itemNotes";
    private static final String OPTIONS = "itemOptions";
    private static final String ADDS = "itemAdds";
    private static final String REMOVES = "itemRemoves";
    private static final String CUSTOMER = "customerName";
    private static final String ACCOUNT_COMMENT = "accountComment";
    private static final String ACCOUNT_NO = "accountNo";
    private static final String ACCOUNT_TYPE = "accountType";
    private static final String ORDER_NO = "orderNo";
    private static final String TICKET_INFO = "ticketInfo";
    private static final String DATE_DUE = "dateDue";
    private static final String TIME_DUE = "timeDue";
    private boolean splitQty = false;
    private final List<SalesItem> items = new ArrayList<SalesItem>();

    public TicketPrepReport(String newFileName) {
        super(newFileName);
    }

    public void setItems(List<SalesItem> itemsToPrint) {
        this.items.clear();
        this.items.addAll(itemsToPrint);
    }

    @Override
    protected JasperReport loadReport() throws JRException {
        return ReportLoader.loadReport(this.getClass(), this.getFileName());
    }

    @Override
    protected JasperPrint runReport(JasperReport report) throws JRException {
        JasperPrint print = null;
        for (SalesItem item : this.items) {
            List<JasperPrint> pages = this.doItem(item, report);
            if (print == null) {
                print = pages.get(0);
                pages.remove(0);
            }
            if (pages.isEmpty()) continue;
            for (JasperPrint nextPage : pages) {
                print = this.addPagesToReport(print, nextPage);
            }
        }
        return print;
    }

    private List<JasperPrint> doItem(SalesItem item, JasperReport report) throws JRException {
        InventoryItem invItem = item.getInventoryItemIfSingle();
        SalesComponent comp = item.getComponentList().get(0);
        String itemLabel = item.getLabel();
        if (invItem != null) {
            itemLabel = invItem.getLabel();
        }
        int count = 1;
        if (this.splitQty && item.getQuantity().greaterThan(SalesQuantity.ONE)) {
            count = item.getQuantity().getValue().intValue();
        }
        ArrayList<JasperPrint> pageList = new ArrayList<JasperPrint>();
        for (int i = 0; i < count; ++i) {
            if (this.splitQty) {
                this.addReportParam(ITEM_DESC, itemLabel);
            } else {
                this.addReportParam(ITEM_DESC, item.getQuantity() + " x " + itemLabel);
            }
            this.addReportParam(ITEM_PRICE, item.getPrice().toString());
            this.addReportParam(ITEM_ID, item.getID());
            this.addStringParam(ITEM_NOTES, item.getNotes());
            if (comp.getUnit().getSize() != null) {
                this.addStringParam(ITEM_SIZE, comp.getUnit().getSize().getShortName());
            } else {
                this.addReportParam(ITEM_SIZE, "");
            }
            this.addReportParam(OPTIONS, this.makeString(this.cullNonPrintable(comp.getCurrentOptions())));
            this.addReportParam(ADDS, this.makeLines(comp.getCurrentPluses()));
            this.addReportParam(REMOVES, this.makeLines(comp.getCurrentMinuses()));
            if (item.getAccount().getCustomer() != null) {
                this.addStringParam(CUSTOMER, item.getAccount().getCustomer().getName());
            } else {
                this.addReportParam(CUSTOMER, "");
            }
            this.addReportParam(ACCOUNT_NO, item.getAccount().getID());
            this.addReportParam(ACCOUNT_TYPE, item.getAccount().getAccountType().getLabel());
            this.addReportParam(ORDER_NO, item.getAccount().getOrderNumber());
            if (!item.getAccount().getTicketData().isEmpty()) {
                this.addStringParam(TICKET_INFO, this.makeStringFromStringList(item.getAccount().getTicketData()));
            } else {
                this.addReportParam(TICKET_INFO, "");
            }
            this.addStringParam(ACCOUNT_COMMENT, item.getAccount().getAccount().getComment());
            if (item.getAccount().getDateDue() != null) {
                this.addStringParam(DATE_DUE, DateTimeUtils.getVeryShortDateFormat().format(item.getAccount().getDateDue()));
            } else {
                this.addReportParam(DATE_DUE, "");
            }
            if (item.getAccount().getTimeDue() != null) {
                this.addStringParam(TIME_DUE, DateTimeUtils.formatTimeForDisplay(item.getAccount().getTimeDue()));
            } else {
                this.addReportParam(TIME_DUE, "");
            }
            JREmptyDataSource data = new JREmptyDataSource();
            JasperPrint page = JasperFillManager.fillReport((JasperReport)report, this.getReportParams(), (JRDataSource)data);
            pageList.add(page);
        }
        return pageList;
    }

    private String makeLines(List<? extends SalesMod> list) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            SB.append(list.get(i).getLabel());
            if (i >= list.size() - 1) continue;
            SB.append("\n");
        }
        return SB.toString();
    }

    private String makeString(List<? extends SalesMod> list) {
        StringBuilder SB = new StringBuilder();
        for (SalesMod salesMod : list) {
            SB.append(salesMod.getLabel());
            SB.append(",");
        }
        if (!list.isEmpty()) {
            SB.replace(SB.length() - 1, SB.length(), "");
        }
        return SB.toString();
    }

    private String makeStringFromStringList(List<String> list) {
        StringBuilder SB = new StringBuilder("");
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            SB.append((Object)it.next());
            if (!it.hasNext()) continue;
            SB.append(", ");
        }
        return SB.toString();
    }

    private List<SalesOption> cullNonPrintable(List<SalesOption> options) {
        ArrayList<SalesOption> list = new ArrayList<SalesOption>();
        for (SalesOption option : options) {
            if (!option.isPrintable()) continue;
            list.add(option);
        }
        return list;
    }

    private void addStringParam(String name, String value) {
        if (value != null) {
            this.addReportParam(name, value);
        } else {
            this.addReportParam(name, "");
        }
    }

    public void setSplitQty(boolean b) {
        this.splitQty = b;
    }
}

