/*
 * Decompiled with CFR 0.152.
 */
package ordermate.reports.table;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.text.Format;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import ordermate.reports.table.ColumnFormat;

public abstract class AbstractColumnFormat
implements ColumnFormat {
    private String name;
    private Class colClass;
    private Format format;
    private TableCellRenderer customRenderer;

    public AbstractColumnFormat(String newName, Class newColClass) {
        this.name = newName;
        this.colClass = newColClass;
    }

    public AbstractColumnFormat(String newName, Class newColClass, Format newFormat) {
        this.name = newName;
        this.colClass = newColClass;
        this.format = newFormat;
    }

    public abstract Object resolveColumnValue(Object var1);

    public AbstractColumnFormat setFormatter(Format newFormat) {
        this.format = newFormat;
        return this;
    }

    public Format getFormatter() {
        return this.format;
    }

    @Override
    public Class getColumnClass() {
        return this.colClass;
    }

    public AbstractColumnFormat setName(String newName) {
        this.name = newName;
        return this;
    }

    @Override
    public Object getIdentifier() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TableCellRenderer getCustomRenderer() {
        if (this.customRenderer != null) {
            return this.customRenderer;
        }
        if (this.format != null) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    DefaultTableCellRenderer comp = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value != null && AbstractColumnFormat.this.format != null) {
                        comp.setText(AbstractColumnFormat.this.format.format(value));
                    }
                    return comp;
                }
            };
        }
        return null;
    }

    public AbstractColumnFormat setCustomRenderer(TableCellRenderer renderer) {
        this.customRenderer = renderer;
        return this;
    }

    @Override
    public Object getValue(Object baseObject) {
        Object value = this.resolveColumnValue(baseObject);
        return value;
    }

    @Override
    public String getStringValue(Object baseObject) {
        Object value = this.getValue(baseObject);
        if (value == null) {
            return "";
        }
        if (this.format != null) {
            return this.format.format(value);
        }
        if (value instanceof Displayable) {
            return ((Displayable)value).getLabel();
        }
        return value.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

