/*
 * Decompiled with CFR 0.152.
 */
package ordermate.scheduler;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportMaker;
import java.util.List;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.email.EmailReportTaskMaster;
import ordermate.scheduler.RecurrenceParser;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class AutoSender {
    private static AutoSender me;
    private Reflections refs = new Reflections("ordermate.database.reports", new Scanner[]{new TypeAnnotationsScanner()});

    private AutoSender() {
    }

    public static AutoSender getInstance() {
        if (me == null) {
            me = new AutoSender();
        }
        return me;
    }

    public <T extends AbstractReportProvider> void doAutoSend(Class<T> reportProvider) {
        Set makers = this.refs.getTypesAnnotatedWith(MakesReport.class);
        for (Class clazz : makers) {
            ReportMaker maker = null;
            try {
                maker = (ReportMaker)clazz.newInstance();
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Could not resolve a maker class for this report provider.", (Throwable)e);
            }
            if (maker == null || !reportProvider.equals(maker.getProvider())) continue;
            this.emailReport(maker.getClass());
        }
    }

    public <T extends ReportMaker> void emailReport(Class<T> reportMaker) {
        List<ReportConfigSchedule> schedules = PersistenceManager.getObjectList(ReportConfigSchedule.class, Query.select(ReportConfigSchedule.class).equals(ReportConfigSchedule.Properties.CRON_SCHEDULE, RecurrenceParser.CronCheatCode.AUTO_SEND.getValue()).equals(ReportConfig.Properties.TYPE, reportMaker.getAnnotation(MakesReport.class).value()).linkUsing(ReportConfigSchedule.Properties.REPORT_CONFIG, ReportConfig.Properties.ID).toString());
        for (ReportConfigSchedule schedule : schedules) {
            EmailReportTaskMaster.getInstance().emailReport(schedule);
        }
    }
}

