/*
 * Decompiled with CFR 0.152.
 */
package ordermate.scheduler;

import au.com.ordermate.util.StringUtils;
import java.text.ParseException;
import java.util.Date;
import ordermate.scheduler.Recurrence;
import ordermate.scheduler.quartz.CronExpression;

public class RecurrenceParser
implements Recurrence {
    public static final String REBOOT = "@reboot";
    public static final String TRADING_DAY = "@tradingday";
    private final String pattern;
    private final CronExpression expression;

    public RecurrenceParser(String pattern) throws ParseException {
        this.pattern = pattern;
        this.expression = !this.isAtReboot() && !this.isAtTradingDay() && !this.isAtAutosend() && !StringUtils.isEmpty(pattern) ? new CronExpression(pattern) : null;
    }

    @Override
    public Date getNextValidTimeAfter(Date date) {
        if (this.isAtReboot()) {
            return null;
        }
        if (this.isAtTradingDay()) {
            return null;
        }
        if (this.isAtAutosend()) {
            return null;
        }
        return this.expression.getNextValidTimeAfter(date);
    }

    @Override
    public boolean isAtReboot() {
        return this.pattern.equalsIgnoreCase(CronCheatCode.REBOOT.getValue());
    }

    @Override
    public boolean isAtTradingDay() {
        return this.pattern.equalsIgnoreCase(CronCheatCode.TRADING_DAY.getValue());
    }

    @Override
    public boolean isAtAutosend() {
        return this.pattern.equalsIgnoreCase(CronCheatCode.AUTO_SEND.getValue());
    }

    public static enum CronCheatCode {
        REBOOT("@reboot"),
        TRADING_DAY("@tradingday"),
        AUTO_SEND("@autosend");

        private String value;

        private CronCheatCode(String aValue) {
            this.value = aValue;
        }

        public String getValue() {
            return this.value;
        }
    }
}

