/*
 * Decompiled with CFR 0.152.
 */
package ordermate.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import ordermate.OrderMate;

public abstract class RetryingExecutor {
    private final long period;
    private boolean success = false;
    private final ExecutorService es = Executors.newSingleThreadExecutor();
    private final Future future;

    public RetryingExecutor(final long period) {
        this.period = period;
        this.future = this.es.submit(new Runnable(){

            @Override
            public void run() {
                while (!RetryingExecutor.this.success) {
                    try {
                        RetryingExecutor.this.execute();
                        RetryingExecutor.this.success = true;
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.info((Object)ex);
                        try {
                            Thread.sleep(period);
                        }
                        catch (InterruptedException ex1) {
                            OrderMate.LOG.debug("Execution interrupted.", (Throwable)ex1);
                            return;
                        }
                        OrderMate.LOG.info("Retrying  after " + period + " ms.");
                    }
                }
            }
        });
    }

    public abstract void execute() throws Exception;

    public Future getFuture() {
        return this.future;
    }
}

