/*
 * Decompiled with CFR 0.152.
 */
package ordermate.scheduler;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import ordermate.OrderMate;
import ordermate.database.schedule.Schedule;
import ordermate.services.misc.CallMethod;
import ordermate.services.misc.CallMethodOnClassExecutable;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class RunNowAction
extends BasicAction {
    public Signal<?, ?, ?, ?, ?> task = Signals.createSignal();
    private List<Schedule> tasksToRun = new ArrayList<Schedule>();

    public RunNowAction() {
        super(HtmlUtils.htmlCenter("Run Now"), IconLoader.get("/ordermate/images/1rightarrow.png"), "Runs selected task(s) instantly");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int dialogResult = JOptionPane.showConfirmDialog(null, "Run selected task(s) now?", "Run Task", 0);
        if (dialogResult == 0) {
            this.task.emit();
            this.run();
        }
    }

    public void setTasksToRun(List<Schedule> tasks) {
        this.tasksToRun.clear();
        this.tasksToRun.addAll(tasks);
    }

    private void run() {
        for (Schedule schedule : this.tasksToRun) {
            try {
                CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable("ordermate.scheduler.Scheduler", new CallMethod("getInstance", new Serializable[0]), new CallMethod("forceRun", schedule));
                PersistenceManager.getServerConnection().runSync(exec);
            }
            catch (Exception e) {
                OrderMate.LOG.error("Failed to run " + schedule.getTask() + " task!", (Throwable)e);
            }
        }
    }
}

