/*
 * Decompiled with CFR 0.152.
 */
package ordermate.scheduler;

import au.com.ordermate.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.misc.TradingDay;
import ordermate.database.schedule.Schedule;
import ordermate.reports.email.EmailReportTask;
import ordermate.scheduler.InvalidRebootTask;
import ordermate.scheduler.Recurrence;
import ordermate.scheduler.RecurrenceParser;
import ordermate.scheduler.ScheduledTask;
import ordermate.scheduler.Task;
import org.apache.logging.log4j.Level;

public class Scheduler {
    private static final int MAX_THREAD = 10;
    private static final Scheduler instance = new Scheduler();
    private ScheduledExecutorService recurrentExeSvc;
    private final ExecutorService fixedExeSvc = Executors.newFixedThreadPool(10);
    private final Map<Schedule, Future> currentTasks = new ConcurrentHashMap<Schedule, Future>();
    private final List<Schedule> atReboot = new ArrayList<Schedule>();
    private final List<Schedule> atTradingDay = new ArrayList<Schedule>();
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");

    private Scheduler() {
    }

    public static Scheduler getInstance() {
        return instance;
    }

    public void startTimer(Schedule schedule) {
        if (this.currentTasks.get(schedule) != null) {
            throw new IllegalArgumentException("A schedule is already started for the schedule " + schedule);
        }
        if (StringUtils.isEmpty(schedule.getRecurrence())) {
            OrderMate.LOG.warn("Will not schedule " + schedule.getLabel() + " empty recurrence");
            return;
        }
        if (!SystemState.ACTIVE_STATE.equals(schedule.getSystemState())) {
            this.endTimer(schedule);
            return;
        }
        Task task = schedule.toTask();
        if (task == null) {
            throw new IllegalArgumentException("The schedule " + schedule + " does not contain a valid task.  No task found for " + schedule.getTask());
        }
        Recurrence recurrence = this.getRecurrence(schedule);
        if (task instanceof InvalidRebootTask && recurrence.isAtReboot()) {
            OrderMate.LOG.warn("The schedule " + task.getName() + " should not be scheduled on reboot.");
            schedule.setRecurrence(RecurrenceParser.CronCheatCode.TRADING_DAY.getValue());
            schedule.save();
            recurrence = this.getRecurrence(schedule);
        }
        if (recurrence.isAtReboot()) {
            this.atReboot.add(schedule);
        } else if (recurrence.isAtTradingDay()) {
            OrderMate.LOG.info("Adding the trading day task for " + schedule);
            this.atTradingDay.add(schedule);
        } else if (!recurrence.isAtAutosend()) {
            OrderMate.LOG.info("Starting the task for " + schedule);
            this.schedule(schedule);
        }
    }

    private Recurrence getRecurrence(Schedule schedule) {
        try {
            return schedule.toRecurrence();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("The schedule " + schedule + " does not contain a valid recurrence.", ex);
        }
    }

    public void endTimer(Schedule schedule) {
        Future future = this.currentTasks.get(schedule);
        if (future != null) {
            OrderMate.LOG.info("Stopping the task for " + schedule);
            future.cancel(false);
            this.currentTasks.remove(schedule);
        } else if (this.atTradingDay.contains(schedule)) {
            OrderMate.LOG.info("Removing the trading day task for " + schedule);
            this.atTradingDay.remove(schedule);
        }
    }

    public void runReboot() {
        for (Schedule schedule : this.atReboot) {
            try {
                Task task = schedule.toTask();
                if (task == null) {
                    OrderMate.LOG.error("The task " + schedule.getTask() + " is not mapped to a registered task for " + schedule);
                    continue;
                }
                Future<?> future = this.fixedExeSvc.submit(task);
                this.currentTasks.put(schedule, future);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error submitting the task for " + schedule, (Throwable)ex);
            }
        }
        this.atReboot.clear();
    }

    public void runTradingDay(TradingDay day) {
        for (Schedule schedule : this.atTradingDay) {
            Task task = schedule.toTask();
            if (task == null) {
                OrderMate.LOG.error("Schedule" + schedule + " is not mapped to a task.");
                continue;
            }
            OrderMate.LOG.info("Start " + task + " for " + day);
            if (!(task instanceof EmailReportTask)) {
                task.setData(day);
            }
            try {
                Future<?> future = this.fixedExeSvc.submit(schedule.toTask());
                this.currentTasks.put(schedule, future);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error submitting the task for " + schedule, (Throwable)ex);
            }
        }
    }

    public void forceRun(Schedule schedule) {
        Task task = schedule.toTask();
        if (task == null) {
            OrderMate.LOG.error("Schedule" + schedule + " is not mapped to a task.");
        } else {
            try {
                Future<?> future = this.fixedExeSvc.submit(task);
                this.currentTasks.put(schedule, future);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error submitting the task for " + schedule, (Throwable)ex);
            }
        }
    }

    void done(Schedule schedule) {
        Recurrence recurrence;
        this.currentTasks.remove(schedule);
        try {
            recurrence = schedule.toRecurrence();
        }
        catch (ParseException ex) {
            throw new IllegalStateException("The recurrence value is invalid for " + schedule, ex);
        }
        if (recurrence.isAtReboot() || recurrence.isAtTradingDay() || recurrence.isAtAutosend()) {
            return;
        }
        long nextDelay = this.getDelayForNextRecurrence(recurrence);
        if (nextDelay > 0L) {
            this.schedule(schedule);
        } else {
            OrderMate.LOG.info("Task " + schedule + " completed and will not be rescheduled.");
        }
    }

    void shutdown() {
        this.recurrentExeSvc.shutdown();
        this.fixedExeSvc.shutdown();
    }

    boolean isAllDone() {
        for (Map.Entry<Schedule, Future> entry : this.currentTasks.entrySet()) {
            Future future = entry.getValue();
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    private void logNextSchedule(Schedule schedule, long delay) {
        Date date = new Date(new Date().getTime() + delay);
        OrderMate.LOG.info("schedule :: " + schedule.getLabel() + " delay : " + delay + " next Scheduled Date : " + this.dateFormat.format(date));
    }

    private void schedule(Schedule schedule) {
        long delay;
        try {
            OrderMate.LOG.info("schedule :: Schedule name : " + schedule.getLabel());
            delay = this.getDelayForNextRecurrence(schedule.toRecurrence());
            this.logNextSchedule(schedule, delay);
        }
        catch (ParseException ex) {
            throw new IllegalStateException("Invalid recurrence for " + schedule, ex);
        }
        if (delay > 0L) {
            if (this.recurrentExeSvc == null) {
                this.restartRecurrentExecutorService();
            }
            ScheduledTask task = new ScheduledTask(schedule);
            ScheduledFuture<?> submit = this.recurrentExeSvc.schedule(task, delay, TimeUnit.MILLISECONDS);
            if (this.currentTasks.containsKey(schedule)) {
                OrderMate.LOG.info("the schedule has already exist: " + schedule.getLabel());
                this.endTimer(schedule);
            }
            this.currentTasks.put(schedule, submit);
            if (this.recurrentExeSvc.isShutdown() || this.recurrentExeSvc.isTerminated()) {
                this.restartRecurrentExecutorService();
            }
        }
    }

    public long getDelayForNextRecurrence(Recurrence recurrence) {
        Date now = new Date();
        Date time = recurrence.getNextValidTimeAfter(now);
        if (time == null) {
            return -1L;
        }
        long next = recurrence.getNextValidTimeAfter(now).getTime() - now.getTime();
        if (next < 7000L) {
            OrderMate.LOG.info("Delay is less than 7 second " + next);
            Date date = new Date();
            Date nextEstimatedDate = new Date(new Date().getTime() + next);
            Date nextScheduledDate = recurrence.getNextValidTimeAfter(nextEstimatedDate);
            next = nextScheduledDate.getTime() - date.getTime();
            OrderMate.LOG.info("Recomputed Delay is : " + next);
        }
        return next;
    }

    public void restartRecurrentExecutorService() {
        try {
            for (Schedule schedule : Schedule.findAll()) {
                this.endTimer(schedule);
            }
            if (this.recurrentExeSvc != null) {
                OrderMate.LOG.log(Level.INFO, "Restarting Schedule Executor Service");
                this.recurrentExeSvc.shutdown();
            } else {
                OrderMate.LOG.log(Level.INFO, "Starting Schedule Executor Service");
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.WARN, "Cannot shut down executor", (Throwable)ex);
        }
        this.recurrentExeSvc = Executors.newScheduledThreadPool(10);
        for (Schedule schedule : Schedule.findAll()) {
            this.currentTasks.remove(schedule);
            try {
                this.startTimer(schedule);
                OrderMate.LOG.info("Schedule " + schedule + " is started.");
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Exception starting scheduled task", (Throwable)ex);
                OrderMate.LOG.info("Delete scheduled task " + schedule);
                schedule.delete();
            }
        }
    }

    public boolean isRunning() {
        return this.recurrentExeSvc != null && !this.recurrentExeSvc.isShutdown() && !this.recurrentExeSvc.isTerminated();
    }
}

