/*
 * Decompiled with CFR 0.152.
 */
package ordermate.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import ordermate.OrderMate;
import ordermate.scheduler.Task;

public enum TaskCreationStrategy {
    Singleton{

        @Override
        public Task getTask(Task task) {
            return task;
        }
    }
    ,
    NewInstance{

        @Override
        public Task getTask(Task task) {
            Task newTask = null;
            try {
                newTask = (Task)task.getClass().newInstance();
            }
            catch (Exception ex) {
                OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
            }
            return newTask;
        }
    };

    private static ConcurrentHashMap<String, Task> nameTaskMap;

    public abstract Task getTask(Task var1);

    public void addTask(Task task) {
        if (!nameTaskMap.containsKey(task.getName())) {
            nameTaskMap.put(task.getName(), task);
        }
    }

    public Task getTaskFromName(String name) {
        return this.getTask(nameTaskMap.get(name));
    }

    public void clear() {
        nameTaskMap.clear();
    }

    static {
        nameTaskMap = new ConcurrentHashMap();
    }
}

