/*
 * Decompiled with CFR 0.152.
 */
package ordermate.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ordermate.scheduler.Task;
import ordermate.scheduler.TaskCreationStrategy;

public class TaskFactory {
    private static final Map<String, TaskCreationStrategy> register = new HashMap<String, TaskCreationStrategy>();
    private static boolean initialized;

    private TaskFactory() {
    }

    public static void initialize() {
        initialized = true;
    }

    public static Task getTask(String taskName) {
        TaskFactory.checkInitialized();
        TaskCreationStrategy strategy = register.get(taskName);
        if (strategy != null) {
            return strategy.getTaskFromName(taskName);
        }
        return null;
    }

    public static void registerTask(Task task) {
        TaskFactory.registerTask(task, TaskCreationStrategy.Singleton);
    }

    public static void registerTask(Task task, TaskCreationStrategy creationStrategy) {
        TaskFactory.checkInitialized();
        if (register.get(task.getName()) != null) {
            throw new IllegalStateException("The task " + task.getName() + " is already registered into the factory.");
        }
        creationStrategy.addTask(task);
        register.put(task.getName(), creationStrategy);
    }

    public static Set<String> getAllTaskName() {
        TaskFactory.checkInitialized();
        return register.keySet();
    }

    public static void clear() {
        TaskCreationStrategy.Singleton.clear();
        register.clear();
    }

    private static void checkInitialized() {
        if (!initialized) {
            throw new UnsupportedOperationException("Cannot use the TaskFactory outside the server.");
        }
    }
}

