/*
 * Decompiled with CFR 0.152.
 */
package ordermate.scheduler.heartbeat;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.scheduler.heartbeat.HeartbeatTask;

public class Heartbeater
extends TimerTask {
    private int millisInAHeartbeat;
    private Set<HeartbeatTask> allTasks;
    private Timer localTimer;

    public Heartbeater(int millis) {
        this.millisInAHeartbeat = millis;
        this.allTasks = new HashSet<HeartbeatTask>();
    }

    public void startHeartBeat() {
        this.startHeartBeat(1L);
    }

    public void startHeartBeat(long delay) {
        this.stopHeartBeat();
        this.localTimer = new Timer();
        this.localTimer.schedule((TimerTask)this, delay, (long)this.millisInAHeartbeat);
    }

    public void stopHeartBeat() {
        if (this.localTimer != null) {
            this.localTimer.cancel();
            this.localTimer = null;
        }
    }

    @Override
    public void run() {
        ArrayList<HeartbeatTask> copyTaskList = new ArrayList<HeartbeatTask>(this.allTasks);
        for (HeartbeatTask task : copyTaskList) {
            task.incrementHearbeats();
            if (!task.checkForRun()) continue;
            try {
                Task toRun = task.getTask();
                new Thread((Runnable)toRun, "HeartBeatTask").start();
                task.resetHearbeats();
            }
            catch (Exception e) {
                OrderMate.LOG.error("HeartbeatTask failed to run", (Throwable)e);
            }
        }
    }

    public void runTaskOnBeats(Task toRun, int beats) {
        AbstractTask abTask;
        if (toRun instanceof AbstractTask && (abTask = (AbstractTask)toRun).isRunOnce()) {
            throw new IllegalStateException("HeartbeatTask need to be repeatable!!");
        }
        HeartbeatTask toAdd = new HeartbeatTask(toRun, beats);
        this.allTasks.add(toAdd);
    }

    public void runTaskOnMillis(Task toRun, int millis) {
        this.runTaskOnBeats(toRun, this.calculateHeartbeat(millis));
    }

    private int calculateHeartbeat(int millis) {
        return (int)Math.ceil(millis / this.millisInAHeartbeat);
    }

    public void removeTask(HeartbeatTask task) {
        this.allTasks.remove(task);
    }

    public int getTaskCount() {
        return this.allTasks.size();
    }
}

