/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security;

import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.User;
import ordermate.gui.binding.validators.EmailValidator;
import ordermate.gui.themes.OrderMateTheme;
import org.jdesktop.beansbinding.Validator;

public abstract class EmailNaggerUI {
    private JFrame parent;
    private boolean finished = false;
    protected boolean verifyMessge = false;
    private EmailValidator emailValidator;
    private User user;
    protected JLabel errorMessage;
    protected JDialog dialog;
    protected JTextField emailField;
    protected JLabel note;
    protected JLabel headerTitle;
    protected JButton skipBtn;
    protected JButton continueBtn;
    protected JLabel message;

    public EmailNaggerUI(JFrame parent) {
        this.parent = parent;
        this.dialog = new JDialog(parent);
        this.dialog.setModal(true);
    }

    public void checkUserLogin(User userInput) {
        this.user = userInput;
        if (StringUtils.isEmpty(this.user.getEmail()) && SystemCurrentInfo.getInstance().isNagForEmail()) {
            this.setupFrame();
            this.setupContent();
            this.showDialog();
        } else if (!this.user.isEmailVerified() && SystemCurrentInfo.getInstance().isNagForEmail()) {
            this.verifyMessge = true;
            this.setupFrame();
            this.headerTitle.setText("Email requires verification!");
            this.message.setText("A confirmation email as been sent to " + this.user.getEmail() + ". Click on the link in the email to activate your user.");
            this.skipBtn.setText("Edit email");
            this.setupContent();
            this.showDialog();
        } else {
            this.finished = true;
        }
    }

    private void showDialog() {
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
        this.dialog.setVisible(true);
    }

    public void closeDialog() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.finished = true;
    }

    private void saveEmail() {
        this.user.setEmail(this.emailField.getText());
        this.user.save();
    }

    private boolean validateEmail(String email) {
        Validator.Result result = this.emailValidator.validate(email);
        if (result == null) {
            User userFound = User.getUserByEmail(email);
            if (userFound != null) {
                this.errorMessage.setForeground(Color.RED);
                this.errorMessage.setText("The entered email is already being used by another user!");
                return false;
            }
            return true;
        }
        this.errorMessage.setForeground(Color.RED);
        this.errorMessage.setText(result.getDescription());
        return false;
    }

    private void setupFrame() {
        this.dialog = new JDialog(this.parent);
        this.dialog.setModal(true);
        this.emailValidator = new EmailValidator();
        this.errorMessage = new JLabel();
        this.emailField = new JTextField();
        this.note = new JLabel();
        this.headerTitle = new JLabel();
        this.skipBtn = new JButton();
        this.continueBtn = new JButton();
        this.message = new JLabel();
        this.emailField.setName("emailField");
        this.skipBtn.setName("skipButton");
        this.continueBtn.setName("continueButton");
        this.dialog.setTitle("emailNagDialog");
        this.dialog.setUndecorated(true);
        this.dialog.getContentPane().setBackground(Color.WHITE);
        this.headerTitle.setHorizontalAlignment(0);
        this.headerTitle.setText("Additional Information Required");
        this.headerTitle.setFont(OrderMateTheme.getLargeFont());
        String messageString = "<html>Hi " + this.user.getFirstName() + "<br><br>An email address is now required for your user credentials. Please enter your email address below and select continue.<br><br>You will receive a confirmation email. Click on the link in the email to activate your user.</html>";
        this.message.setText(messageString);
        this.message.setVerticalAlignment(1);
        this.message.setFont(OrderMateTheme.getMediumFont());
        this.errorMessage.setFont(OrderMateTheme.getSmallFont());
        this.emailField.setText("Email");
        this.emailField.setFont(OrderMateTheme.getMediumFont());
        this.skipBtn.setText("Skip");
        this.skipBtn.setFont(OrderMateTheme.getMediumFont());
        this.skipBtn.setOpaque(false);
        this.skipBtn.setContentAreaFilled(false);
        this.skipBtn.setRolloverEnabled(false);
        this.skipBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailNaggerUI.this.closeDialog();
                if (EmailNaggerUI.this.verifyMessge) {
                    EmailNaggerUI.this.user.setEmail("");
                    EmailNaggerUI.this.user.save();
                    EmailNaggerUI.this.verifyMessge = false;
                    EmailNaggerUI.this.setupFrame();
                    EmailNaggerUI.this.setupContent();
                    EmailNaggerUI.this.showDialog();
                }
            }
        });
        this.continueBtn.setText("Continue");
        this.continueBtn.setFont(OrderMateTheme.getMediumFont());
        this.continueBtn.setOpaque(false);
        this.continueBtn.setContentAreaFilled(false);
        this.continueBtn.setRolloverEnabled(false);
        this.continueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EmailNaggerUI.this.verifyMessge) {
                    EmailNaggerUI.this.closeDialog();
                } else if (EmailNaggerUI.this.validateEmail(EmailNaggerUI.this.emailField.getText())) {
                    EmailNaggerUI.this.saveEmail();
                    EmailNaggerUI.this.closeDialog();
                }
            }
        });
        this.note.setText("<HTML>NOTE: selecting skip will prompt this message when next logging in.</HTML>");
        this.note.setFont(OrderMateTheme.getSmallerFont());
    }

    protected abstract void setupContent();

    public void gotText(String value) {
        if (value != null) {
            this.emailField.setText(value);
        } else {
            this.emailField.setText("");
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

