/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import ordermate.OrderMate;
import ordermate.database.misc.ConfigTermsOfService;
import ordermate.database.misc.ConfigTermsOfServiceUserLink;
import ordermate.database.users.User;
import ordermate.gui.themes.OrderMateTheme;

public abstract class ToSNaggerUI {
    protected boolean accepted = false;
    protected JDialog dialog;
    protected JLabel headerTitle;
    protected JLabel logo;
    protected JButton acceptBtn;
    protected JButton declineBtn;
    protected JLabel message;
    private User user;
    protected ConfigTermsOfService latestTOS;

    public ToSNaggerUI(JFrame parent) {
        this.dialog = new JDialog(parent);
        this.dialog.setModal(true);
    }

    public void checkUserLogin(User userInput) {
        this.user = userInput;
        this.latestTOS = ConfigTermsOfService.getLatestTOS();
        if (this.latestTOS != null) {
            ConfigTermsOfServiceUserLink userTOSLink = ConfigTermsOfServiceUserLink.getTOSLinkFromUser(userInput);
            if (userTOSLink == null || !this.latestTOS.getTOSVersion().equals(userTOSLink.getTOSVersion())) {
                this.setupComponents();
                this.setupContentFrame();
                this.showDialog();
            } else if (userTOSLink != null || this.latestTOS.getTOSVersion().equals(userTOSLink.getTOSVersion())) {
                this.accepted = true;
            }
        } else {
            OrderMate.LOG.info("There are no terms of service stored in the local db!");
            this.accepted = true;
        }
    }

    private void setupComponents() {
        this.headerTitle = new JLabel();
        this.logo = new JLabel();
        this.acceptBtn = new JButton();
        this.declineBtn = new JButton();
        this.message = new JLabel();
        this.acceptBtn.setName("acceptButton");
        this.declineBtn.setName("declineButton");
        this.dialog.setTitle("tosDialog");
        this.dialog.setUndecorated(true);
        this.dialog.getContentPane().setBackground(Color.WHITE);
        this.headerTitle.setHorizontalAlignment(0);
        this.headerTitle.setText("Terms of Service");
        this.headerTitle.setFont(OrderMateTheme.getLargeFont());
        ImageIcon icon = IconLoader.get("/ordermate/images/logo_2024_transparent.png");
        this.logo.setIcon(new ImageIcon(icon.getImage().getScaledInstance(100, 50, 4)));
        this.message.setText("<html>By choosing \"Accept\" below you agree to OrderMates's Terms of Service.</html>");
        this.message.setVerticalAlignment(1);
        this.declineBtn.setText("Decline");
        this.declineBtn.setFont(OrderMateTheme.getMediumFont());
        this.declineBtn.setOpaque(false);
        this.declineBtn.setContentAreaFilled(false);
        this.declineBtn.setRolloverEnabled(false);
        this.declineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderMate.LOG.info("User: " + ToSNaggerUI.this.user.getFirstName() + " " + ToSNaggerUI.this.user.getLastName() + " linked with " + ToSNaggerUI.this.user.getEmail() + " declinded the terms of service agreement version - " + ToSNaggerUI.this.latestTOS.getTOSVersion() + ". ");
                OrderMate.LOG.info("Login declined!");
                ToSNaggerUI.this.closeDialog();
            }
        });
        this.acceptBtn.setEnabled(false);
        this.acceptBtn.setFont(OrderMateTheme.getMediumFont());
        this.acceptBtn.setText("Accept");
        this.acceptBtn.setOpaque(false);
        this.acceptBtn.setContentAreaFilled(false);
        this.acceptBtn.setRolloverEnabled(false);
        this.acceptBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToSNaggerUI.this.saveToSAgreement();
                ToSNaggerUI.this.accepted = true;
                ToSNaggerUI.this.closeDialog();
                OrderMate.LOG.info("User: " + ToSNaggerUI.this.user.getFirstName() + " " + ToSNaggerUI.this.user.getLastName() + " linked with " + ToSNaggerUI.this.user.getEmail() + " accepeted the terms of service agreement version - " + ToSNaggerUI.this.latestTOS.getTOSVersion() + ". ");
            }
        });
    }

    protected abstract void setupContentFrame();

    private void showDialog() {
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
        this.dialog.setVisible(true);
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private void saveToSAgreement() {
        ConfigTermsOfServiceUserLink userAgreement = new ConfigTermsOfServiceUserLink(this.user, this.latestTOS.getTOSVersion());
        userAgreement.save();
    }

    public boolean isAccepted() {
        return this.accepted;
    }
}

