/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import ordermate.OrderMate;

public class UniqueServiceHelper {
    private static final String SEPERATOR_CHAR = "@";

    public static Long getProcessID() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            if (name != null && name.indexOf(SEPERATOR_CHAR) > -1) {
                return Long.valueOf(name.substring(0, name.indexOf(SEPERATOR_CHAR)));
            }
            OrderMate.LOG.error("Error occured while fetching the PID within: " + name);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured while fetching the PID.", (Throwable)ex);
        }
        OrderMate.LOG.error("Error occured while fetching the PID, returning null.");
        return null;
    }

    public static boolean isProcessRunning(long pid, String user) {
        try {
            String processOutputLine;
            Runtime runtime = Runtime.getRuntime();
            String[] cmds = user != null ? new String[]{"cmd", "/c", "tasklist", "/FI", "\"PID eq " + pid + "\"", "/FI", "\"USERNAME eq " + user + "\""} : new String[]{"cmd", "/c", "tasklist", "/FI", "\"PID eq " + pid + "\""};
            Process process = runtime.exec(cmds);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((processOutputLine = bufferedReader.readLine()) != null) {
                if (!processOutputLine.contains(String.valueOf(pid))) continue;
                return true;
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured when checking if process with pid: " + pid + ", was running.");
        }
        return false;
    }
}

