/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security;

import java.util.concurrent.Semaphore;
import org.apache.commons.collections.map.MultiKeyMap;

public class UniqueServiceLocks {
    private final MultiKeyMap locks = new MultiKeyMap();
    private static UniqueServiceLocks instance;
    public static final Long SUCCESS_RESULT_CODE;
    public static final Long ERROR_RESULT_CODE;

    private UniqueServiceLocks() {
    }

    public static synchronized UniqueServiceLocks getInstance() {
        if (instance == null) {
            instance = new UniqueServiceLocks();
        }
        return instance;
    }

    public synchronized Long tryLock(String serviceName, String terminal, long pid) {
        UniqueLock lock;
        if (this.locks.containsKey((Object)serviceName, (Object)terminal)) {
            lock = (UniqueLock)this.locks.get((Object)serviceName, (Object)terminal);
        } else {
            lock = new UniqueLock();
            this.locks.put((Object)serviceName, (Object)terminal, (Object)lock);
        }
        boolean result = lock.lock(pid);
        if (!result) {
            return lock.getPid();
        }
        return SUCCESS_RESULT_CODE;
    }

    public synchronized Long unLock(String serviceName, String terminal, long pid) {
        if (this.locks.containsKey((Object)serviceName, (Object)terminal)) {
            UniqueLock lock = (UniqueLock)this.locks.get((Object)serviceName, (Object)terminal);
            if (lock.unlock(pid)) {
                return SUCCESS_RESULT_CODE;
            }
            return lock.getPid();
        }
        return ERROR_RESULT_CODE;
    }

    public synchronized Long tryReacquireLock(String serviceName, String terminal, long pid) {
        UniqueLock lock;
        boolean result = false;
        if (this.locks.containsKey((Object)serviceName, (Object)terminal)) {
            lock = (UniqueLock)this.locks.get((Object)serviceName, (Object)terminal);
            result = lock.reacquireLock(pid);
        } else {
            lock = new UniqueLock();
            this.locks.put((Object)serviceName, (Object)terminal);
            result = lock.lock(pid);
        }
        if (!result) {
            return lock.getPid();
        }
        return SUCCESS_RESULT_CODE;
    }

    synchronized void clearLocks() {
        this.locks.clear();
    }

    static {
        SUCCESS_RESULT_CODE = 0L;
        ERROR_RESULT_CODE = -1L;
    }

    private static final class UniqueLock {
        private static final int NUMBER_OF_PERMITS = 1;
        private Semaphore lock = new Semaphore(1);
        private long pid;

        public synchronized boolean lock(long pid) {
            boolean lockResult = this.lock.tryAcquire();
            if (lockResult) {
                this.pid = pid;
            }
            return this.isLockedBy(pid);
        }

        public synchronized boolean unlock(long pid) {
            if (this.isLockedBy(pid)) {
                this.lock.release();
                this.pid = -1L;
                return true;
            }
            return false;
        }

        public synchronized boolean reacquireLock(long pid) {
            this.lock.release();
            return this.lock(pid);
        }

        public long getPid() {
            return this.pid;
        }

        public boolean isLockedBy(long pid) {
            return this.pid == pid;
        }
    }
}

