/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security;

import au.com.ordermate.persistence.Executable;
import ordermate.security.UniqueServiceLocks;

public class UniqueTaskLockService
extends Executable<Long> {
    private final UniqueTaskLockCommand command;
    private final String service;
    private final String terminal;
    private final long pid;

    public UniqueTaskLockService(UniqueTaskLockCommand command, String service, String terminal, long pid) {
        this.command = command;
        this.service = service;
        this.terminal = terminal;
        this.pid = pid;
    }

    @Override
    public Long execute() {
        switch (this.command) {
            case LOCK: {
                return UniqueServiceLocks.getInstance().tryLock(this.service, this.terminal, this.pid);
            }
            case UNLOCK: {
                return UniqueServiceLocks.getInstance().unLock(this.service, this.terminal, this.pid);
            }
            case REAQUIRE: {
                return UniqueServiceLocks.getInstance().tryReacquireLock(this.service, this.terminal, this.pid);
            }
        }
        return UniqueServiceLocks.ERROR_RESULT_CODE;
    }

    public static enum UniqueTaskLockCommand {
        LOCK,
        UNLOCK,
        REAQUIRE;

    }
}

