/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security.impl;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import java.sql.ResultSet;
import java.sql.SQLException;
import ordermate.database.DBConnectionInterface;
import ordermate.security.impl.DongleThread;
import ordermate.security.impl.SecurityManager;

class DatabaseThread
extends Thread {
    private static final int ERROR_THRESHOLD = 6;
    private static final long PERIOD = 30000L;
    private int errorCount;
    private DBConnectionInterface dc;

    public DatabaseThread(DBConnectionInterface conn) {
        super("Database check");
        this.dc = conn;
    }

    @Override
    public void run() {
        while (true) {
            try {
                DatabaseThread.sleep(30000L);
            }
            catch (InterruptedException e) {
                SecurityManager.SECURITY_LOG.warn("Sleep cycle interuppted.", (Throwable)e);
            }
            this.waiterMateCheck();
        }
    }

    private void waiterMateCheck() {
        this.check("WaiterMate", SecurityManager.getSecurityDetails().getNumWaitermateTerminals());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String type, int num) {
        block9: {
            try {
                int count = 0;
                Object[] params = new Object[]{type};
                ResultSet rs = null;
                try {
                    rs = this.dc.executeQuery(this.getEntriesQuery().toString(), params);
                    while (rs.next()) {
                        if (++count <= num || !DongleThread.dongleConnect()) continue;
                        int id = rs.getInt("ID");
                        Object[] delParams = new Object[]{new Integer(id)};
                        this.dc.execute(this.getDeletePS().toString(), delParams);
                    }
                }
                finally {
                    if (rs != null) {
                        this.dc.release(rs);
                    }
                }
                if (count > num && DongleThread.dongleConnect()) {
                    SecurityManager.SECURITY_LOG.error("Deleted " + Math.abs(num - count) + " " + type + " record(s).");
                }
                this.errorCount = 0;
            }
            catch (SQLException e) {
                SecurityManager.SECURITY_LOG.error("SQLException caught while attempting to check entries.", (Throwable)e);
                ++this.errorCount;
                if (this.errorCount <= 6) break block9;
                SecurityManager.SECURITY_LOG.error("Exiting due to too many database errors.");
                SecurityManager.exit();
            }
        }
    }

    private ObjectQuery getEntriesQuery() {
        return new ObjectQuerySQLAdapter("SELECT config_terminal.ID FROM config_terminal WHERE config_terminal.system_state = 'ACTIVE' AND config_terminal.type = ? ");
    }

    private ObjectQuery getDeletePS() {
        return new ObjectQuerySQLAdapter("UPDATE config_terminal SET system_state = 'DELETED' WHERE ID = ? ");
    }
}

