/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security.impl;

import java.util.Calendar;
import ordermate.security.impl.DateUtils;
import ordermate.security.impl.SecurityDetails;
import ordermate.security.impl.SecurityManager;

class ExpiryThread
extends Thread {
    private static final long DELAY = 300000L;
    private static final long PERIOD = 300000L;

    public ExpiryThread() {
        super("Expiry check");
    }

    @Override
    public void run() {
        SecurityDetails details = SecurityManager.getSecurityDetails();
        try {
            ExpiryThread.sleep(300000L);
        }
        catch (InterruptedException e) {
            SecurityManager.SECURITY_LOG.warn("ExpiryThread initial delay interrupted.", (Throwable)e);
        }
        while (true) {
            Calendar runDate = Calendar.getInstance();
            runDate.setTime(details.getLastRunDate());
            Calendar expiryDate = Calendar.getInstance();
            expiryDate.setTime(details.getExpiryDate());
            Calendar currentDate = DateUtils.getDate();
            if (currentDate.before(runDate)) {
                SecurityManager.SECURITY_LOG.error("Failure on previous run date.  Previous run date : " + runDate + ", current date must be after this.");
                SecurityManager.exit();
            }
            if (currentDate.after(expiryDate)) {
                SecurityManager.SECURITY_LOG.error("Failure on expiry date.");
                SecurityManager.exit();
            }
            SecurityManager.getSecurityDetails().setLastRunDate(currentDate.getTime());
            try {
                ExpiryThread.sleep(300000L);
                continue;
            }
            catch (InterruptedException e) {
                SecurityManager.SECURITY_LOG.warn("ExpiryThread sleep cycle interrupted.", (Throwable)e);
                this.interrupt();
                continue;
            }
            break;
        }
    }
}

