/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class HashWithFixedSalt {
    public static String hashWithFixedSalt(String data, String salt) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(salt.getBytes());
        byte[] hashedData = md.digest(data.getBytes());
        byte[] saltAndHash = new byte[salt.getBytes().length + hashedData.length];
        System.arraycopy(salt.getBytes(), 0, saltAndHash, 0, salt.getBytes().length);
        System.arraycopy(hashedData, 0, saltAndHash, salt.getBytes().length, hashedData.length);
        return DatatypeConverter.printBase64Binary((byte[])saltAndHash);
    }

    public static String extractHash(String combinedSaltAndHash, int saltLength) {
        byte[] saltAndHash = DatatypeConverter.parseBase64Binary((String)combinedSaltAndHash);
        byte[] hash = new byte[saltAndHash.length - saltLength];
        System.arraycopy(saltAndHash, saltLength, hash, 0, hash.length);
        return DatatypeConverter.printBase64Binary((byte[])hash);
    }

    public static boolean verifyHash(String data, String combinedSaltAndHash, String salt) throws NoSuchAlgorithmException {
        String newHash = HashWithFixedSalt.hashWithFixedSalt(data, salt);
        return newHash.equals(combinedSaltAndHash);
    }
}

