/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security.impl;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.MACAddress;
import au.com.ordermate.util.StringUtils;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.dbconnection.AbstractDatabaseConnection;
import ordermate.encryption.MD5Hash;
import ordermate.security.impl.DatabaseThread;
import ordermate.security.impl.DateUtils;
import ordermate.security.impl.DongleThread;
import ordermate.security.impl.ExpiryThread;
import ordermate.security.impl.LicenceExceptionHandler;
import ordermate.security.impl.SecurityDetails;
import ordermate.security.impl.db.ServerMateServiceDBSecurityDetails;
import ordermate.security.impl.dongle.DongleSecurityDetails;
import org.apache.logging.log4j.core.Logger;

public class SecurityManager {
    public static final Logger SECURITY_LOG;
    static boolean checked;
    private static SecurityManager securityManager;
    private HashSet deliveryModeLicenses = new HashSet();
    private SecurityDetails details = this.createDetails();
    private LicenceExceptionHandler handler;
    private final SecurityMode mode;
    private final Date actingMasterDate;

    private SecurityManager(SecurityMode secMode, Date dateSinceActingMaster, LicenceExceptionHandler yourHandler) {
        this.handler = yourHandler;
        this.actingMasterDate = dateSinceActingMaster;
        this.mode = secMode != null ? secMode : SecurityMode.Normal;
    }

    public void start() {
        int countdown = 10;
        while (!this.checkMacAddress() && !this.handleBadMac(countdown)) {
            if (countdown <= 0) {
                OrderMate.LOG.warn("Invalid MAC identified, shutting down immediately");
                SecurityManager.exit();
            }
            --countdown;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            OrderMate.LOG.warn("Invalid MAC, will shut down servermate in " + countdown + " minutes");
        }
        if (this.checkMacAddress()) {
            OrderMate.LOG.warn("Valid MAC identified");
        }
        DBConnectionInterface conn = null;
        try {
            conn = AbstractDatabaseConnection.getDBConnectionInterface(null);
        }
        catch (Exception e) {
            SECURITY_LOG.error("Could not obtain data from ConfigurationService.", (Throwable)e);
            SecurityManager.exit();
        }
        if (SecurityMode.Normal.equals((Object)this.mode)) {
            DongleThread dongleThread = new DongleThread();
            dongleThread.start();
        }
        DatabaseThread databaseThread = new DatabaseThread(conn);
        ExpiryThread expiryThread = new ExpiryThread();
        databaseThread.start();
        expiryThread.start();
    }

    public static SecurityManager getInstance() {
        if (securityManager == null) {
            throw new IllegalStateException("Cannot call getInstance on Security Manager before calling initialise.");
        }
        return securityManager;
    }

    public static synchronized void initialise(SecurityMode secMode, Date actingMasterDate, LicenceExceptionHandler exHandler) {
        if (securityManager == null) {
            securityManager = new SecurityManager(secMode, actingMasterDate, exHandler);
        }
    }

    public static synchronized boolean isInitialised() {
        return securityManager != null;
    }

    private final SecurityDetails createDetails() {
        ServerMateServiceDBSecurityDetails dbDetails = new ServerMateServiceDBSecurityDetails();
        try {
            dbDetails.acquireLicense();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot load the db dongle, will try for dongle.", (Throwable)ex);
        }
        if (dbDetails.isSecurityPresent()) {
            OrderMate.LOG.info("DB Dongle used for security.");
            return dbDetails;
        }
        OrderMate.LOG.info("Physical Dongle used for security");
        return new DongleSecurityDetails();
    }

    private boolean checkMacAddress() {
        if (!SecurityMode.Normal.equals((Object)this.mode)) {
            if (SecurityMode.Slave.equals((Object)this.mode)) {
                return true;
            }
            Date failoverDate = this.actingMasterDate;
            Calendar cal = Calendar.getInstance();
            cal.add(5, -7);
            if (failoverDate != null && failoverDate.after(cal.getTime())) {
                return true;
            }
            return this.handler.staleActingMaster();
        }
        List<String> macAddressArray = MACAddress.getMacAddress();
        String value = this.details.getRecordedMacAddress();
        if (value == null || value.isEmpty()) {
            SECURITY_LOG.info("NO MAC Address Defined!");
            return false;
        }
        if (!macAddressArray.contains(value = value.toUpperCase())) {
            macAddressArray.addAll(MACAddress.getMacAddressFromScript());
            if (macAddressArray.contains(value)) {
                return true;
            }
            SECURITY_LOG.error("Security check failed: MAC addresses do not match.  Expected " + value + " but found " + macAddressArray.toString());
            return false;
        }
        SECURITY_LOG.info("Valid MAC address verified.");
        return true;
    }

    private boolean handleBadMac(int countdown) {
        SecurityManager.getInstance().handler.handleException(countdown);
        this.details = this.createDetails();
        return this.checkMacAddress();
    }

    private void stop() {
        this.details.releaseLicense();
    }

    public static String getExpiryDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(SecurityManager.securityManager.details.getExpiryDate());
        return DateUtils.toString(cal, true);
    }

    public static String updateKey(String key) {
        Calendar writeDate = null;
        String mac = "";
        List<String> macAddressArray = MACAddress.getMacAddress();
        Iterator<String> it = macAddressArray.iterator();
        while (it.hasNext()) {
            String drawer = it.next().toString();
            mac = drawer.toString();
        }
        Date expire = SecurityManager.securityManager.details.getExpiryDate();
        Calendar expiryDate = Calendar.getInstance();
        expiryDate.setTime(expire);
        expiryDate.set(5, 1);
        expiryDate.add(2, 1);
        String date = DateUtils.toString(expiryDate, false);
        if (key.equals(MD5Hash.hash((String)(mac.trim() + date.trim())))) {
            writeDate = DateUtils.copy(expiryDate);
        }
        expiryDate.add(2, 2);
        date = DateUtils.toString(expiryDate, false);
        if (key.equals(MD5Hash.hash((String)(mac.trim() + date.trim())))) {
            writeDate = DateUtils.copy(expiryDate);
        }
        expiryDate.add(2, 3);
        date = DateUtils.toString(expiryDate, false);
        if (key.equals(MD5Hash.hash((String)(mac.trim() + date.trim())))) {
            writeDate = DateUtils.copy(expiryDate);
        }
        expiryDate.add(2, 6);
        date = DateUtils.toString(expiryDate, false);
        if (key.equals(MD5Hash.hash((String)(mac.trim() + date.trim())))) {
            writeDate = DateUtils.copy(expiryDate);
        }
        if (writeDate != null) {
            SecurityManager.securityManager.details.setExpiryDate(writeDate.getTime());
            return "Expiry date updated to " + DateUtils.toString(writeDate, true) + ".";
        }
        return "Invalid key.";
    }

    public static synchronized boolean acquireHomeDeliveryLicense(Terminal terminal) {
        if (SecurityManager.securityManager.deliveryModeLicenses.contains(terminal)) {
            return true;
        }
        if (SecurityManager.securityManager.deliveryModeLicenses.size() < PersistentLicenseManager.getInstance().getLicenseValue(LicenseType.NumHomeDelivery)) {
            SecurityManager.securityManager.deliveryModeLicenses.add(terminal);
            return true;
        }
        SECURITY_LOG.warn("License was refused for : " + terminal + ",  Current num delivery licenses : " + SecurityManager.securityManager.deliveryModeLicenses.size() + ", Num licensed : " + PersistentLicenseManager.getInstance().getLicenseValue(LicenseType.NumHomeDelivery) + ", Terminals currently licensed for home delivery, " + StringUtils.arrayToString(SecurityManager.securityManager.deliveryModeLicenses.toArray()));
        return false;
    }

    public static void exit() {
        try {
            SecurityManager.getInstance().handler.handleException(0);
            if (securityManager != null) {
                securityManager.stop();
            }
        }
        finally {
            System.exit(1);
        }
    }

    public static void checkAgain() {
        JFrame errorFrame = new JFrame("Security Check Failure");
        Container pane = errorFrame.getContentPane();
        pane.setLayout(new GridBagLayout());
        JLabel retryLabel = new JLabel();
        retryLabel.setHorizontalAlignment(0);
        retryLabel.setText("<html><h1>Security Check Failure</h1><br><h3>System will check again after 60 Seconds</h3></html>");
        pane.add(retryLabel);
        errorFrame.setSize(450, 450);
        errorFrame.setVisible(true);
        int i = 60;
        while (i > 0 && i <= 60) {
            retryLabel.setText("<html><h1>Security Check Failure</h1><br><h3>System will check again after " + --i + " Seconds</h3></html>");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        errorFrame.setVisible(false);
        checked = true;
    }

    public static SecurityDetails getSecurityDetails() {
        return SecurityManager.securityManager.details;
    }

    public static boolean isChecked() {
        return checked;
    }

    static {
        checked = false;
        String baseDirectory = System.getProperty("log.root") + "ServerMate" + File.separator + "Security" + File.separator;
        SECURITY_LOG = OrderMateLog.createLogger(baseDirectory, "Security");
    }

    public static enum SecurityMode {
        Normal,
        ActingMaster,
        Slave;

    }
}

