/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security.impl.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ordermate.OrderMate;
import ordermate.dbconnection.DatabaseConnectionFactory;
import ordermate.encryption.BlowfishEasy;

class DBLicenseHelper {
    private final String CONNECT = "SELECT count(*) FROM system_dongle";
    private final String UPDATE = "UPDATE system_dongle SET dongle_value = ? WHERE dongle_field = ?";
    private final String SELECT = "SELECT dongle_value FROM system_dongle WHERE dongle_field = ?";
    private BlowfishEasy blowit = new BlowfishEasy("CUSTOMIS TAKING THE WORLD HEAD ON!");
    private Connection con;
    private PreparedStatement connectStm;
    private PreparedStatement updateStm;
    private PreparedStatement selectStm;

    DBLicenseHelper() {
    }

    private boolean acquireConnection() {
        block6: {
            try {
                if (this.con != null && !this.con.isClosed()) {
                    return true;
                }
                if (this.con != null && !this.con.isClosed()) break block6;
                DatabaseConnectionFactory factory = new DatabaseConnectionFactory();
                try {
                    this.setConnection(factory.connectDB());
                    return true;
                }
                catch (ClassNotFoundException ex) {
                    OrderMate.LOG.error("Couldn't connect to the database for dongle duty.", (Throwable)ex);
                }
                catch (SQLException ex) {
                    OrderMate.LOG.error("Couldn't connect to the database for dongle duty.", (Throwable)ex);
                }
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Could not determine if the connection was closed or not.", (Throwable)ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean canRead() {
        if (!this.acquireConnection()) {
            return false;
        }
        ResultSet rs = null;
        boolean allGood = false;
        try {
            rs = this.connectStm.executeQuery();
            rs.first();
            int count = rs.getInt(1);
            allGood = count > 5;
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Couldn't check if the db dongle can read.", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex2) {
                    OrderMate.LOG.error("Couldn't close off the result set after checking db dongle can read.", (Throwable)ex2);
                }
            }
        }
        return allGood;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String read(String field) {
        this.acquireConnection();
        ResultSet rs = null;
        String value = null;
        try {
            this.selectStm.setString(1, field);
            rs = this.selectStm.executeQuery();
            value = rs.first() ? rs.getString(1) : null;
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Couldn't read from the db dongle.", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex2) {
                    OrderMate.LOG.error("Couldn't close off the result set reading from the db dongle.", (Throwable)ex2);
                }
            }
        }
        if (value != null) {
            return this.blowit.decryptString(value);
        }
        return "0";
    }

    synchronized void write(String field, Object value) {
        this.acquireConnection();
        String strValue = String.valueOf(value);
        strValue = this.blowit.encryptString(strValue);
        try {
            this.updateStm.setString(1, strValue);
            this.updateStm.setString(2, field);
            this.updateStm.executeUpdate();
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Couldn't write to the db dongle.", (Throwable)ex);
        }
    }

    synchronized void releaseResources() {
        try {
            if (this.con != null) {
                this.con.close();
            }
            this.con = null;
            if (this.connectStm != null) {
                this.connectStm.close();
            }
            if (this.updateStm != null) {
                this.updateStm.close();
            }
            if (this.selectStm != null) {
                this.selectStm.close();
            }
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Couldn't close off resources for db dongle.", (Throwable)ex);
        }
    }

    public synchronized void setConnection(Connection value) {
        this.releaseResources();
        this.con = value;
        try {
            this.connectStm = this.con.prepareStatement("SELECT count(*) FROM system_dongle");
            this.updateStm = this.con.prepareStatement("UPDATE system_dongle SET dongle_value = ? WHERE dongle_field = ?");
            this.selectStm = this.con.prepareStatement("SELECT dongle_value FROM system_dongle WHERE dongle_field = ?");
        }
        catch (SQLException ex) {
            OrderMate.LOG.error("Couldn't create prepared statements for dongle.", (Throwable)ex);
        }
    }
}

