/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security.impl.db;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.security.impl.SecurityDetails;
import ordermate.security.impl.db.DBLicenseHelper;

public class DBSecurityDetails
implements SecurityDetails {
    private static final String EXPIRY = "expiry";
    private static final String LAST_RUN = "last_run";
    private static final String NUM_WAITERMATE = "num_wm";
    private static final String HASH = "license_hash";
    private static final String MAC = "mac_address";
    private static final String DB_USER = "db_user";
    private static final String DB_PASS = "db_pass";
    private String hash;
    private Date expiry;
    private Date lastRun;
    private int numWaitermate;
    private String mac;
    private String dbUser;
    private String dbPass;
    private DBLicenseHelper helper = new DBLicenseHelper();

    public DBSecurityDetails() {
    }

    public DBSecurityDetails(Connection con) {
        this();
        this.helper.setConnection(con);
    }

    @Override
    public void acquireLicense() throws Exception {
        if (!this.helper.canRead()) {
            throw new IllegalStateException("Unable to establish a connection to the database dongle.");
        }
    }

    @Override
    public void releaseLicense() {
        this.helper.releaseResources();
    }

    @Override
    public Date getExpiryDate() {
        try {
            String dongleTime = this.helper.read(EXPIRY);
            long time = Long.parseLong(dongleTime);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(time);
            this.expiry = cal.getTime();
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("There was a problem with the database dongle.", (Throwable)ex);
        }
        return this.expiry;
    }

    @Override
    public void setExpiryDate(Date value) {
        this.helper.write(EXPIRY, value.getTime());
    }

    @Override
    public Date getLastRunDate() {
        try {
            String dongleTime = this.helper.read(LAST_RUN);
            long time = Long.parseLong(dongleTime);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(time);
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.lastRun = cal.getTime();
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("There was a problem with the database dongle.", (Throwable)ex);
        }
        return this.lastRun;
    }

    @Override
    public void setLastRunDate(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.helper.write(LAST_RUN, cal.getTimeInMillis());
    }

    @Override
    public int getNumWaitermateTerminals() {
        try {
            this.numWaitermate = Integer.parseInt(this.helper.read(NUM_WAITERMATE));
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Error trying to read in the number of waitermate terminals.", (Throwable)ex);
            this.numWaitermate = 0;
        }
        return this.numWaitermate;
    }

    @Override
    public String getLicenseHash() {
        try {
            this.hash = this.helper.read(HASH);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Error trying to read in the license hash.", (Throwable)ex);
        }
        return this.hash;
    }

    @Override
    public void setLicenseHash(String hash) {
        this.helper.write(HASH, hash);
    }

    @Override
    public String getRecordedMacAddress() {
        try {
            this.mac = this.helper.read(MAC);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Error trying to read in the MAC Address.", (Throwable)ex);
        }
        if (this.mac == null) {
            this.mac = "";
        }
        return this.mac;
    }

    @Override
    public void setRecordedMacAddress(String value) {
        this.helper.write(MAC, value);
    }

    @Override
    public void preSave() {
    }

    @Override
    public void clear() {
        String clearValue = "0";
        this.helper.write(LAST_RUN, clearValue);
        this.helper.write(EXPIRY, clearValue);
        this.helper.write(NUM_WAITERMATE, clearValue);
        this.helper.write(HASH, clearValue);
        this.helper.write(MAC, clearValue);
    }

    @Override
    public void setNumWaitermateTerminals(int num) {
        this.helper.write(NUM_WAITERMATE, Integer.toString(num));
    }

    @Override
    public void setDBUsername(String value) {
        this.helper.write(DB_USER, value);
    }

    @Override
    public String getDBUsername() {
        try {
            this.dbUser = this.helper.read(DB_USER);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in DB Username from DBLicense", (Throwable)ex);
        }
        return this.dbUser;
    }

    @Override
    public void setDBPassword(String value) {
        this.helper.write(DB_PASS, value);
    }

    @Override
    public String getDBPassword() {
        try {
            this.dbPass = this.helper.read(DB_PASS);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in DB Password from DBLicense", (Throwable)ex);
        }
        return this.dbPass;
    }

    @Override
    public boolean isSecurityPresent() {
        return this.helper.canRead();
    }

    @Override
    public String getType() {
        return "Database Security";
    }
}

