/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security.impl.dongle;

import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import ordermate.OrderMate;
import ordermate.security.impl.DateUtils;
import ordermate.security.impl.SecurityDetails;
import ordermate.security.impl.dongle.SentinelManager;

public class DongleSecurityDetails
implements SecurityDetails {
    private static final String SCHEMA_VERSION = "1";
    private static final String SCHEMA_ADDRESS = "08";
    private static final String KNOWN_VALUE_ADDRESS = "1B";
    private static final String KNOWN_VALUE = "E30C";
    private static String EXPIRY_DATE_ADDRESS_1 = "0B";
    private static String EXPIRY_DATE_ADDRESS_2 = "19";
    private static String RUN_DATE_ADDRESS_1 = "32";
    private static String RUN_DATE_ADDRESS_2 = "11";
    private static final String WAITERMATE_ADDRESS = "29";
    private static final String USERNAME_ADDRESS = "12";
    private static final int DATABASE_LENGTH = 12;
    private static final String PASSWORD_ADDRESS = "38";
    private static String MAC_ADDRESS_1 = "23";
    private static String MAC_ADDRESS_2 = "24";
    private static String MAC_ADDRESS_3 = "25";
    private static final String ADDRESS = "1B";
    private static final String VALUE = "E30C";
    private static final String LICENSE_1 = "0D";
    private static final String LICENSE_2 = "0E";
    private static final String LICENSE_3 = "0F";
    private static final String LICENSE_4 = "1D";
    private static final String LICENSE_5 = "1E";
    private static final String LICENSE_6 = "1F";
    private static final String LICENSE_7 = "2E";
    private static final String LICENSE_8 = "2F";
    private static final String LICENSE_9 = "3E";
    private static final String LICENSE_10 = "3F";
    private final SentinelManager sentinelManager = new SentinelManager();

    public static boolean canConnect() {
        try {
            return SentinelManager.donglePresent();
        }
        catch (Throwable ex) {
            OrderMate.LOG.error("Cannot load Sentinel Manager, cannot use dongle");
            return false;
        }
    }

    @Override
    public void acquireLicense() throws Exception {
        this.sentinelManager.obtainLicense();
    }

    @Override
    public void releaseLicense() {
        this.sentinelManager.releaseLicense();
    }

    @Override
    public Date getLastRunDate() {
        int i;
        int b1 = SentinelManager.hexToDec(this.sentinelManager.read(RUN_DATE_ADDRESS_1));
        int b2 = SentinelManager.hexToDec(this.sentinelManager.read(RUN_DATE_ADDRESS_2));
        String block1 = String.valueOf(b1);
        String block2 = String.valueOf(b2);
        int diff = 4 - block1.length();
        for (i = 0; i < diff; ++i) {
            block1 = "0" + block1;
        }
        diff = 4 - block2.length();
        for (i = 0; i < diff; ++i) {
            block2 = "0" + block2;
        }
        String day = String.valueOf(block2.charAt(0)) + String.valueOf(block1.charAt(2));
        String month = String.valueOf(block1.charAt(0)) + String.valueOf(block2.charAt(2));
        String year = String.valueOf(block1.charAt(1)) + String.valueOf(block2.charAt(3)) + String.valueOf(block1.charAt(3)) + String.valueOf(block2.charAt(1));
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day));
        return cal.getTime();
    }

    @Override
    public void setLastRunDate(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        String text = DateUtils.toString(cal, false);
        String dayText = text.substring(0, 2);
        String monthText = text.substring(2, 4);
        String yearText = text.substring(4, 8);
        String block1 = String.valueOf(monthText.charAt(0)) + String.valueOf(yearText.charAt(0)) + String.valueOf(dayText.charAt(1)) + String.valueOf(yearText.charAt(2));
        String block2 = String.valueOf(dayText.charAt(0)) + String.valueOf(yearText.charAt(3)) + String.valueOf(monthText.charAt(1)) + String.valueOf(yearText.charAt(1));
        int b1 = Integer.parseInt(block1);
        int b2 = Integer.parseInt(block2);
        this.sentinelManager.write(RUN_DATE_ADDRESS_1, SentinelManager.decToHex(b1, 4), (byte)0);
        this.sentinelManager.write(RUN_DATE_ADDRESS_2, SentinelManager.decToHex(b2, 4), (byte)0);
    }

    @Override
    public int getNumWaitermateTerminals() {
        String waitermate = this.sentinelManager.read(WAITERMATE_ADDRESS);
        int waitermateLicenses = SentinelManager.hexToDec(waitermate);
        return waitermateLicenses;
    }

    @Override
    public void setNumWaitermateTerminals(int num) {
        this.sentinelManager.write(WAITERMATE_ADDRESS, SentinelManager.decToHex(num, 4), (byte)0);
    }

    @Override
    public String getLicenseHash() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.sentinelManager.read(LICENSE_1, 4));
        buffer.append(this.sentinelManager.read(LICENSE_2, 4));
        buffer.append(this.sentinelManager.read(LICENSE_3, 4));
        buffer.append(this.sentinelManager.read(LICENSE_4, 4));
        buffer.append(this.sentinelManager.read(LICENSE_5, 4));
        buffer.append(this.sentinelManager.read(LICENSE_6, 4));
        buffer.append(this.sentinelManager.read(LICENSE_7, 4));
        buffer.append(this.sentinelManager.read(LICENSE_8, 4));
        buffer.append(this.sentinelManager.read(LICENSE_9, 4));
        buffer.append(this.sentinelManager.read(LICENSE_10, 4));
        return buffer.toString();
    }

    @Override
    public void setLicenseHash(String keyString) {
        int index = 0;
        boolean success = true;
        success &= this.sentinelManager.write(LICENSE_1, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_2, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_3, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_4, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_5, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_6, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_7, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_8, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_9, keyString.substring(index, index += 4), (byte)0) == 0;
        success &= this.sentinelManager.write(LICENSE_10, keyString.substring(index, index += 4), (byte)0) == 0;
    }

    @Override
    public void setExpiryDate(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        String text = DateUtils.toString(cal, false);
        String dayText = text.substring(0, 2);
        String monthText = text.substring(2, 4);
        String yearText = text.substring(4, 8);
        String block1 = String.valueOf(monthText.charAt(0)) + String.valueOf(yearText.charAt(0)) + String.valueOf(dayText.charAt(1)) + String.valueOf(yearText.charAt(2));
        String block2 = String.valueOf(dayText.charAt(0)) + String.valueOf(yearText.charAt(3)) + String.valueOf(monthText.charAt(1)) + String.valueOf(yearText.charAt(1));
        int b1 = Integer.parseInt(block1);
        int b2 = Integer.parseInt(block2);
        this.sentinelManager.write(EXPIRY_DATE_ADDRESS_1, SentinelManager.decToHex(b1, 4), (byte)0);
        this.sentinelManager.write(EXPIRY_DATE_ADDRESS_2, SentinelManager.decToHex(b2, 4), (byte)0);
    }

    @Override
    public Date getExpiryDate() {
        Calendar expiryDate = DateUtils.getDate(SentinelManager.hexToDec(this.sentinelManager.read(EXPIRY_DATE_ADDRESS_1)), SentinelManager.hexToDec(this.sentinelManager.read(EXPIRY_DATE_ADDRESS_2)));
        return expiryDate.getTime();
    }

    @Override
    public String getRecordedMacAddress() {
        String dongle1 = this.sentinelManager.read(MAC_ADDRESS_1, 4).toUpperCase();
        String dongle2 = this.sentinelManager.read(MAC_ADDRESS_2, 4).toUpperCase();
        String dongle3 = this.sentinelManager.read(MAC_ADDRESS_3, 4).toUpperCase();
        return dongle1 + dongle2 + dongle3;
    }

    @Override
    public void setRecordedMacAddress(String value) {
        if (value.length() != 12) {
            throw new IllegalArgumentException("Cannot have a mac address less than 12 characters:" + value);
        }
        this.sentinelManager.write(MAC_ADDRESS_1, value.substring(0, 4), (byte)0);
        this.sentinelManager.write(MAC_ADDRESS_2, value.substring(4, 8), (byte)0);
        this.sentinelManager.write(MAC_ADDRESS_3, value.substring(8, 12), (byte)0);
    }

    @Override
    public void preSave() {
        this.randomize();
        this.sentinelManager.write(SCHEMA_ADDRESS, SCHEMA_VERSION, (byte)0);
        this.sentinelManager.write("1B", "E30C", (byte)0);
    }

    private void randomize() {
        Random random = new Random();
        for (int address = SentinelManager.hexToDec(SCHEMA_ADDRESS); address <= SentinelManager.hexToDec(LICENSE_10); ++address) {
            int data = random.nextInt(65536);
            this.sentinelManager.write(SentinelManager.decToHex(address, 4), SentinelManager.decToHex(data, 4), (byte)0);
        }
    }

    @Override
    public void clear() {
        for (int address = SentinelManager.hexToDec(SCHEMA_ADDRESS); address <= SentinelManager.hexToDec(LICENSE_10); ++address) {
            this.sentinelManager.write(SentinelManager.decToHex(address, 4), "", (byte)0);
        }
    }

    @Override
    public void setDBUsername(String value) {
        String username = value;
        int diff = 12 - value.length();
        for (int i = 0; i < diff; ++i) {
            username = value.concat(" ");
        }
        this.sentinelManager.writeString(USERNAME_ADDRESS, username, (byte)0);
    }

    @Override
    public String getDBUsername() {
        return this.sentinelManager.readString(USERNAME_ADDRESS, 6);
    }

    @Override
    public String getDBPassword() {
        return this.sentinelManager.readString(PASSWORD_ADDRESS, 6);
    }

    @Override
    public void setDBPassword(String value) {
        String password = value;
        int diff = 12 - password.length();
        for (int i = 0; i < diff; ++i) {
            password = password.concat(" ");
        }
        this.sentinelManager.writeString(PASSWORD_ADDRESS, password, (byte)0);
    }

    @Override
    public boolean isSecurityPresent() {
        String data = this.sentinelManager.read("1B");
        return data.equalsIgnoreCase("E30C");
    }

    @Override
    public String getType() {
        return "Dongle Security";
    }
}

