/*
 * Decompiled with CFR 0.152.
 */
package ordermate.security.impl.dongle;

import ordermate.security.impl.SecurityManager;
import rainbow.SentinelSuperpro;

class SentinelManager {
    static final String ERROR_STRING = "\u0000";
    static final int SUCCESS = 0;
    private static final String DEVELOPER_ID = "199E";
    private static final String WRITE_PASSWORD = "4F90";
    private static final String OVERWRITE_PASSWORD_1 = "DD47";
    private static final String OVERWRITE_PASSWORD_2 = "12A5";
    static final byte READ_WRITE = 0;
    static final byte READ_ONLY = 1;
    static final byte COUNTER = 2;
    static final byte ALGORITHM = 4;
    private SentinelSuperpro sentinel;
    private byte[] apiPacket;

    SentinelManager() {
        this.setup();
    }

    public static boolean donglePresent() {
        try {
            int devID = SentinelManager.hexToDec(DEVELOPER_ID);
            SentinelSuperpro sentinel = new SentinelSuperpro();
            byte[] apiPacket = new byte[4112];
            int result = 0;
            result |= sentinel.RNBOsproFormatPacket(apiPacket, apiPacket.length);
            result |= sentinel.RNBOsproInitialize(apiPacket);
            result |= sentinel.RNBOsproFindFirstUnit(apiPacket, devID);
            int[] bytes = new int[1];
            return (result |= sentinel.RNBOsproRead(apiPacket, 11, bytes)) == 0 && bytes[0] != 0;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void setup() {
        this.sentinel = new SentinelSuperpro();
        this.apiPacket = new byte[4112];
        int result = this.sentinel.RNBOsproFormatPacket(this.apiPacket, this.apiPacket.length);
        if (result != 0) {
            SecurityManager.SECURITY_LOG.error("API Packet NOT formatted; code " + result);
            SecurityManager.exit();
        }
        if ((result = this.sentinel.RNBOsproInitialize(this.apiPacket)) == 0) {
            SecurityManager.SECURITY_LOG.info("Security interface initialized.");
        } else {
            SecurityManager.SECURITY_LOG.error("API Packet NOT initialized; code = " + result);
            SecurityManager.exit();
        }
        this.sentinel.RNBOsproSetContactServer(this.apiPacket, "no-net");
        int devID = SentinelManager.hexToDec(DEVELOPER_ID);
        result = this.sentinel.RNBOsproFindFirstUnit(this.apiPacket, devID);
        if (result == 0) {
            SecurityManager.SECURITY_LOG.info("License obtained.");
        } else if (!SecurityManager.isChecked()) {
            SecurityManager.SECURITY_LOG.error("Could not obtain a license in first time check; code = " + result);
            SecurityManager.checkAgain();
            result = this.sentinel.RNBOsproFindFirstUnit(this.apiPacket, devID);
            if (result == 0) {
                SecurityManager.SECURITY_LOG.info("License obtained.");
            } else {
                SecurityManager.SECURITY_LOG.error("Could not obtain a license; code = " + result);
                SecurityManager.exit();
            }
        } else {
            SecurityManager.SECURITY_LOG.error("Could not obtain a license; code = " + result);
            SecurityManager.exit();
        }
    }

    synchronized void obtainLicense() throws Exception {
        this.sentinel = new SentinelSuperpro();
        this.apiPacket = new byte[4112];
        int result = this.sentinel.RNBOsproFormatPacket(this.apiPacket, this.apiPacket.length);
        if (result != 0) {
            throw new Exception("API Packet NOT formatted.  Error Code: " + result);
        }
        result = this.sentinel.RNBOsproInitialize(this.apiPacket);
        if (result != 0) {
            throw new Exception("API Packet NOT initialized.  Error Code: " + result);
        }
        this.sentinel.RNBOsproSetContactServer(this.apiPacket, "no-net");
        int devID = SentinelManager.hexToDec(DEVELOPER_ID);
        result = this.sentinel.RNBOsproFindFirstUnit(this.apiPacket, devID);
        if (result != 0) {
            throw new Exception("Could not obtain a license for the API Packet.  Error Code: " + result);
        }
    }

    synchronized void releaseLicense() {
        int[] empty = new int[]{0};
        this.sentinel.RNBOsproReleaseLicense(this.apiPacket, 0, empty);
    }

    public synchronized String read(String address) {
        return this.read(address, -1);
    }

    synchronized String read(String address, int length) {
        int[] data;
        int intAddress = SentinelManager.hexToDec(address);
        int result = this.sentinel.RNBOsproRead(this.apiPacket, intAddress, data = new int[1]);
        if (result == 0) {
            return SentinelManager.decToHex(data[0], length);
        }
        return ERROR_STRING;
    }

    String readString(String address, int numCells) {
        int intAddress = SentinelManager.hexToDec(address);
        StringBuffer buffer = new StringBuffer();
        int cellsRead = 0;
        boolean error = false;
        while (cellsRead < numCells && !error) {
            int[] data = new int[1];
            int result = this.sentinel.RNBOsproRead(this.apiPacket, intAddress, data);
            if (result != 0) {
                error = true;
                continue;
            }
            String str = SentinelManager.decToHex(data[0], 4);
            String hex1 = str.substring(0, 2);
            String hex2 = str.substring(2, 4);
            int ascii1 = SentinelManager.hexToDec(hex1);
            int ascii2 = SentinelManager.hexToDec(hex2);
            char char1 = (char)ascii1;
            char char2 = (char)ascii2;
            buffer.append(char1);
            buffer.append(char2);
            ++intAddress;
            ++cellsRead;
        }
        return buffer.toString().trim();
    }

    synchronized int write(String address, String data, byte type) {
        int result = this.sentinel.RNBOsproOverwrite(this.apiPacket, SentinelManager.hexToDec(WRITE_PASSWORD), SentinelManager.hexToDec(OVERWRITE_PASSWORD_1), SentinelManager.hexToDec(OVERWRITE_PASSWORD_2), SentinelManager.hexToDec(address), SentinelManager.hexToDec(data), type);
        return result;
    }

    synchronized int writeString(String address, String data, byte type) {
        int result = 0;
        if (data.length() % 2 != 0) {
            data = data.concat(" ");
        }
        int intAddress = SentinelManager.hexToDec(address);
        for (int i = 0; i < data.length(); i += 2) {
            char c;
            char ascii = c = data.charAt(i);
            String hex1 = SentinelManager.decToHex(ascii, 2);
            ascii = c = data.charAt(i + 1);
            String hex2 = SentinelManager.decToHex(ascii, 2);
            int res = this.write(SentinelManager.decToHex(intAddress, 4), hex1 + hex2, type);
            if (res > result) {
                result = res;
            }
            ++intAddress;
        }
        return result;
    }

    static String decToHex(int decValue, int length) {
        StringBuffer hexValueBuffer = new StringBuffer();
        for (int quotient = decValue; quotient > 0 || hexValueBuffer.length() < length; quotient /= 16) {
            int remainder = quotient % 16;
            char hexChar = remainder <= 9 ? (char)(remainder + 48) : (char)(remainder + 55);
            hexValueBuffer.append(hexChar);
        }
        return hexValueBuffer.reverse().toString();
    }

    static int hexToDec(String hexValue) {
        int value = 0;
        String hexString = new String(hexValue.toUpperCase());
        for (int i = 0; i < hexString.length(); ++i) {
            if (hexString.charAt(i) < '0' || hexString.charAt(i) > '9' && hexString.charAt(i) < 'A' || hexString.charAt(i) > 'F') {
                return -1;
            }
            int hexToDec = hexString.charAt(i) >= '0' && hexString.charAt(i) <= '9' ? hexString.charAt(i) - 48 : hexString.charAt(i) - 55;
            value += hexToDec * (int)Math.pow(16.0, hexString.length() - 1 - i);
        }
        return value;
    }
}

