/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection;

import java.io.IOException;
import java.net.UnknownHostException;
import ordermate.OrderMate;
import ordermate.serverconnection.ConnectionChecker;
import ordermate.serverconnection.ServerConnectionManager;

public class ConnectionCheckThread
implements Runnable {
    private final long PERIOD;
    private static ConnectionCheckThread instance;
    private ServerConnectionManager manager;
    private boolean checkConnection;
    private Thread runningThread = null;

    private ConnectionCheckThread(ServerConnectionManager newManager) {
        this(newManager, 1000L);
    }

    public ConnectionCheckThread(ServerConnectionManager newManager, long checkTime) {
        this.manager = newManager;
        this.PERIOD = checkTime;
        this.checkConnection = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.PERIOD);
            }
            catch (InterruptedException e) {
                OrderMate.LOG.info("Thread interupted while waiting", (Throwable)e);
            }
            ConnectionCheckThread connectionCheckThread = this;
            synchronized (connectionCheckThread) {
                boolean connected;
                if (this.checkConnection && !(connected = this.performCheck())) {
                    OrderMate.LOG.info("Blocking from Connection Check Thread");
                    this.manager.connect();
                    OrderMate.LOG.info("Unblocking from Connection Check Thread");
                }
            }
        }
    }

    private boolean performCheck() {
        boolean connected = false;
        try {
            connected = ConnectionChecker.check(this.manager);
        }
        catch (UnknownHostException e) {
            OrderMate.LOG.warn("Could not find host '" + this.manager.getAddress() + "' while checking connection", (Throwable)e);
        }
        catch (IOException e) {
            OrderMate.LOG.warn("IOException connecting to server '" + this.manager.getAddress() + "' while checking connection", (Throwable)e);
        }
        catch (SecurityException e) {
            OrderMate.LOG.warn("SecurityException '" + this.manager.getAddress() + "' while checking connection", (Throwable)e);
        }
        return connected;
    }

    public synchronized void setChecking(boolean checking) {
        this.checkConnection = checking;
    }

    public static ConnectionCheckThread getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Must call ConnectionCheckThread.setupInstance() before calling getInstance");
        }
        return instance;
    }

    public static boolean isSetup() {
        return instance != null;
    }

    public static ConnectionCheckThread setupInstance(ServerConnectionManager newManager) {
        if (instance != null) {
            throw new IllegalStateException("ConnectionCheckThread has already been setup");
        }
        instance = new ConnectionCheckThread(newManager);
        return instance;
    }

    public void setRunningThread(Thread thread) {
        this.runningThread = thread;
    }

    public Thread getRunningThread() {
        return this.runningThread;
    }
}

