/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection;

import java.io.IOException;
import java.net.InetAddress;
import ordermate.OrderMate;
import ordermate.serverconnection.ConnectionCheckerStrategy;
import ordermate.serverconnection.DefaultSMConnectionCheckerStrategy;
import ordermate.serverconnection.ServerConnectionManager;

public class ConnectionChecker {
    private static ConnectionChecker instance = new ConnectionChecker();
    private ConnectionCheckerStrategy strategy;
    private InetAddress prevSuccessfulConnect;

    public ConnectionChecker() {
        if (this.strategy == null) {
            this.strategy = new DefaultSMConnectionCheckerStrategy();
        }
    }

    public static boolean check(ServerConnectionManager manager) throws IOException {
        return instance.performCheck(manager);
    }

    public static final void setStrategy(ConnectionCheckerStrategy strategy) {
        if (strategy != null) {
            ConnectionChecker.instance.strategy = strategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean performCheck(ServerConnectionManager manager) throws IOException {
        String serverAddress = manager.getAddress();
        InetAddress address = InetAddress.getByName(serverAddress);
        if (this.prevSuccessfulConnect != null && !this.prevSuccessfulConnect.equals(address)) {
            OrderMate.LOG.warn("Could be two terminals on the network with name OrderMate.\nServer address is not equal to the previous successful address. Previous Address : " + this.prevSuccessfulConnect + ", current address :" + address);
        }
        ConnectionChecker connectionChecker = this;
        synchronized (connectionChecker) {
            this.strategy.check(address);
        }
        this.prevSuccessfulConnect = address;
        return true;
    }

    public ConnectionCheckerStrategy getStrategy() {
        return this.strategy;
    }
}

