/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import ordermate.OrderMate;
import ordermate.persistence.remote.RemotePersistence;
import ordermate.serverconnection.ConnectionCheckerStrategy;
import ordermate.serverconnection.VersionCheck;

public class DefaultSMConnectionCheckerStrategy
implements ConnectionCheckerStrategy {
    private static final int NETWORK_TIMEOUT = 2000;
    private final VersionCheck versionCheck;
    private final boolean isRMICheckEnabled;
    private volatile long connectExceptionCount = 1L;

    public DefaultSMConnectionCheckerStrategy() {
        String value;
        boolean checkRMI = true;
        this.versionCheck = new VersionCheck();
        if (Config.isConfigSetup() && !StringUtils.isEmpty(value = Config.getStringValue("skip_socket_reachable_check"))) {
            checkRMI = value != null && value.equalsIgnoreCase("true");
        }
        this.isRMICheckEnabled = checkRMI;
    }

    @Override
    public void check(InetAddress address) throws IOException {
        if (!this.isReachableViaRMI()) {
            this.isReachableViaSocket(address);
        }
    }

    private boolean isReachableViaRMI() {
        if (!this.isRMICheckEnabled) {
            return false;
        }
        boolean result = false;
        boolean versionCheckValid = false;
        try {
            result = versionCheckValid = this.isVersionCheckValid();
            if (!result) {
                this.logDetails(null);
            }
            this.connectExceptionCount = 1L;
        }
        catch (Exception ex) {
            this.logDetails(ex);
        }
        return result;
    }

    boolean isReachableViaSocket(InetAddress address) throws IOException {
        try {
            Socket socket = new Socket(address, this.getConnectionCheckerPort());
            socket.close();
            return true;
        }
        catch (Exception ex) {
            this.logDetails(ex);
            throw new IOException(ex);
        }
    }

    int getConnectionCheckerPort() {
        return 9900;
    }

    boolean isRMIInitialized() {
        return SimpleRMI.isInitialized();
    }

    boolean isVersionCheckValid() throws RemoteException {
        if (PersistenceManager.isPersistenceSetup() && PersistenceManager.getPersistenceDelegate() instanceof RemotePersistence) {
            return ((RemotePersistence)((Object)PersistenceManager.getPersistenceDelegate())).ping() != null;
        }
        return this.versionCheck.isValid();
    }

    private void logDetails(Exception ex) {
        ++this.connectExceptionCount;
        if (this.connectExceptionCount % 100L == 0L) {
            OrderMate.LOG.debug("Connection Check via RMI failed", (Throwable)ex);
        } else {
            OrderMate.LOG.debug("Connection Check via RMI failed");
        }
    }
}

