/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection;

import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.serverconnection.ConnectionManagerScreen;

public class ManagerScreenWrapper
implements ConnectionManagerScreen {
    private ConnectionManagerScreen connectionScreen;
    private int reconnectCount;

    public ManagerScreenWrapper(ConnectionManagerScreen toWrap) {
        this.connectionScreen = toWrap;
    }

    public void showConnectionInterface(boolean invokeLater) {
        if (invokeLater) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManagerScreenWrapper.this.connectionScreen.showConnectionInterface();
                    ManagerScreenWrapper.this.connectionScreen.setNumRetries("Servermate", 0);
                }
            });
        } else {
            this.connectionScreen.showConnectionInterface();
            this.connectionScreen.setNumRetries("Servermate", 0);
        }
    }

    @Override
    public void showConnectionInterface() {
        boolean invokeLater = !SwingUtilities.isEventDispatchThread();
        this.showConnectionInterface(invokeLater);
    }

    @Override
    public void hideConnectionInterface() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManagerScreenWrapper.this.connectionScreen.hideConnectionInterface();
            }
        });
    }

    @Override
    public void setNumRetries(final String server, int newConnectCount) {
        this.reconnectCount = newConnectCount;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManagerScreenWrapper.this.connectionScreen.setNumRetries(server, ManagerScreenWrapper.this.reconnectCount);
            }
        });
    }

    @Override
    public void displayVersionWarningDialog(final String serverVersion) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManagerScreenWrapper.this.connectionScreen.displayVersionWarningDialog(serverVersion);
            }
        });
    }

    @Override
    public void connectedToServer(final boolean isRedundant, final String currentServer) {
        OrderMate.LOG.info("Connection reestablished to server:" + currentServer + ", removing gui.");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManagerScreenWrapper.this.connectionScreen.connectedToServer(isRedundant, currentServer);
            }
        });
    }
}

