/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.MathsUtils;
import java.rmi.RemoteException;
import ordermate.OrderMate;
import ordermate.serverconnection.PropertiesServerClient;
import ordermate.serverconnection.VersionCheck;
import ordermate.startup.OrderMateSetupException;

public class PropertiesServerCheckTask
extends AbstractTask {
    private static final long ONE_GB = 0x40000000L;
    private static final long FIVE_GB = 0x140000000L;

    @Override
    public String getName() {
        return "Start Server Properties check.";
    }

    @Override
    protected int getTotalSubTasks() {
        return 2;
    }

    @Override
    protected void performTask() throws Exception {
        this.checkVersion();
        this.emitProgress();
        this.checkHardDriveSpace();
        this.emitProgress();
    }

    private void checkVersion() {
        VersionCheck check = new VersionCheck();
        try {
            if (!check.isValid()) {
                throw new OrderMateSetupException((Task)this, "The server is running a different version.", "The server version (" + check.getServerVersion() + ") is not " + OrderMate.VERSION + ".<BR>This may result in erratic behaviour.", new String[]{"Update the client to have the " + check.getServerVersion() + " version.", "Get the latest stable version of server and client."}, true);
            }
        }
        catch (RemoteException ex) {
            throw new OrderMateSetupException((Task)this, "Could not compare server version.", new String[]{"Manually check that the server version is " + OrderMate.VERSION, "Restart waitermate"}, false);
        }
    }

    private void checkHardDriveSpace() throws Exception {
        long minHardBytes;
        PropertiesServerClient.connect();
        Long hdSize = (Long)PropertiesServerClient.getProperty("Server HD Space");
        long l = minHardBytes = Config.isDebuging() ? 0x80000000L : 0x140000000L;
        if (hdSize < minHardBytes) {
            boolean fatal = hdSize < minHardBytes / 5L;
            String hdSizeString = MathsUtils.roundDoubleToDecPlaces(hdSize / 0x40000000L, 1) + "";
            String msg = fatal ? "The server is out of disk space: " : "The server is running out of disk space: ";
            throw new OrderMateSetupException((Task)this, msg + hdSizeString + " GB", new String[]{"Clear out old backups in C:\\backup on the server", "Empty the recycle bin on the server", "Call OrderMate Technical Support"}, fatal);
        }
    }
}

