/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.simplermi.SimpleRMI;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.List;
import ordermate.OrderMate;
import ordermate.serverconnection.PropertiesServer;

public class PropertiesServerClient {
    private static PropertiesServer server = null;

    private PropertiesServerClient() {
    }

    public static void connect() throws RemoteException {
        List<String> addresses = Config.getStringListValue("app_server");
        if (addresses.isEmpty() || addresses.get(0).isEmpty()) {
            throw new RemoteException("The server is not configured, the property 'app_server' is not found in the configuration.");
        }
        OrderMate.LOG.info("Property Check Addresses:" + addresses);
        Exception lastException = null;
        for (String nextServer : addresses) {
            try {
                OrderMate.LOG.info("Checking Properties for:" + nextServer);
                InetAddress serverIp = InetAddress.getByName(nextServer);
                server = (PropertiesServer)SimpleRMI.getObject(serverIp, "Properties Service", 11100);
                lastException = null;
                break;
            }
            catch (Exception e) {
                lastException = e;
                OrderMate.LOG.error((Object)e);
            }
        }
        if (lastException != null) {
            throw new RemoteException("Cannot access server properties:", lastException);
        }
    }

    public static Object getProperty(String propertyName) throws RemoteException, IllegalArgumentException {
        if (server == null) {
            PropertiesServerClient.connect();
        }
        try {
            return server.getProperty(propertyName);
        }
        catch (Exception ex) {
            if (server != null) {
                OrderMate.LOG.error("Throwing away cached server for properties check and reconnecting for property name " + propertyName);
            }
            server = null;
            PropertiesServerClient.connect();
            return server.getProperty(propertyName);
        }
    }
}

