/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.database.DatabaseMaintenanceService;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceWrapper;
import au.com.ordermate.persistence.UnsafePersistence;
import au.com.ordermate.persistence.UnsafePersistenceWrapper;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.database.LPAPersistenceDelegate;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.IPAddressUtils;
import au.com.ordermate.util.Price;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.ServerConnectionManagerI;
import ordermate.database.Data;
import ordermate.database.DataService;
import ordermate.database.hardware.Terminal;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.internationalization.Internationalization;
import ordermate.maps.AllMappings;
import ordermate.persistence.remote.RMIPersistenceLayer;
import ordermate.persistence.remote.RMIPersistenceRetriever;
import ordermate.persistence.remote.RemotePersistence;
import ordermate.serverconnection.ConnectionCheckThread;
import ordermate.serverconnection.ConnectionChecker;
import ordermate.serverconnection.ConnectionManagerScreen;
import ordermate.serverconnection.Gate;
import ordermate.serverconnection.ManagerScreenWrapper;
import ordermate.serverconnection.VersionCheck;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import ordermate.startup.SetupMeasureUnitTask;
import ordermate.timesync.TimeClient;

public class ServerConnectionManager
implements ServerConnectionManagerI {
    private static final int PAUSE_TIME = 1000;
    private static ServerConnectionManager instance;
    private int reconnectCount = -1;
    private String currentServer;
    private List<String> servers;
    private boolean secondaryServer = false;
    private AtomicBoolean registerRemoteCache = new AtomicBoolean(true);
    private final String localTerminalType;
    private final Gate connected;
    private ManagerScreenWrapper gui;
    private final Runnable reconnectionTask;
    private final Semaphore reconnectSemaphore = new Semaphore(1);
    private final VersionCheck versionCheck = new VersionCheck();
    private LPAPersistenceDelegate persistenceDelegate;
    public static final Signal reconnectSignal;
    private static volatile long failedConnectionCount;

    private ServerConnectionManager(List<String> newServers, ConnectionManagerScreen screen, String terminalType, Runnable reconnectTask) {
        this.servers = newServers;
        if (screen != null) {
            this.gui = new ManagerScreenWrapper(screen);
        }
        this.connected = new Gate();
        this.localTerminalType = terminalType;
        this.reconnectionTask = reconnectTask;
    }

    void connect() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Do not call connect from event dispatch thread!");
        }
        if (this.tryConnect() == ServerConnectionManagerI.ServerConnectionStatus.ConnectionSuccess) {
            OrderMate.LOG.info("Quick connect worked, returning...");
            if (this.gui != null) {
                this.gui.hideConnectionInterface();
                this.gui.connectedToServer(this.secondaryServer, this.currentServer);
            }
            return;
        }
        this.connected.setValue(false);
        this.doReconnectWork(false);
    }

    private boolean doReconnectWork(boolean alreadyClaimedSemaphore) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.reconnectSemaphore.tryAcquire()) {
                OrderMate.LOG.info("launching reconnect off the edt.");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ServerConnectionManager.this.doReconnectWork(true);
                    }
                }, "ReconnectWork").start();
            }
            throw new IllegalStateException("Should not be calling reconnect work from the EDT");
        }
        if (!alreadyClaimedSemaphore && !this.reconnectSemaphore.tryAcquire()) {
            OrderMate.LOG.info("Already trying to reconnect. Will not start a new thread.");
            return false;
        }
        OrderMate.LOG.info("Disconnection detected, starting doReconnectWork()");
        this.reconnectCount = 0;
        if (this.gui != null) {
            this.gui.showConnectionInterface();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.info("Thread interrupted while waiting", (Throwable)e);
            Thread.interrupted();
        }
        OrderMate.LOG.info("Looping to perform reconnect work.");
        while (this.tryConnect() != ServerConnectionManagerI.ServerConnectionStatus.ConnectionSuccess) {
            ++this.reconnectCount;
            OrderMate.LOG.info("Still not connected after " + this.reconnectCount + " connection attempts");
            if (this.gui != null) {
                OrderMate.LOG.info("Updating connection interface");
                this.gui.setNumRetries(this.currentServer, this.reconnectCount);
                OrderMate.LOG.info("Updating connection interface.  Done!");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                OrderMate.LOG.info("Thread interrupted while waiting", (Throwable)e);
                Thread.interrupted();
            }
        }
        reconnectSignal.emit();
        OrderMate.LOG.info("Reconnected after " + this.reconnectCount + " connection attempts!");
        this.reconnectCount = -1;
        if (this.gui != null) {
            OrderMate.LOG.info("Hiding connection interface");
            this.gui.hideConnectionInterface();
            OrderMate.LOG.info("Hiding connection interface. Done!");
        }
        if (this.gui != null) {
            this.gui.connectedToServer(this.secondaryServer, this.currentServer);
        }
        OrderMate.LOG.info("ServerConnectionManager setting Gate value to true after connecting to server in thread " + Thread.currentThread().getName() + "-" + Thread.currentThread().getId());
        this.connected.setValue(true);
        try {
            if (!this.versionCheck.isValid()) {
                OrderMate.LOG.warn("Exiting due to mismatch between servermate and client application.");
                this.gui.displayVersionWarningDialog(this.versionCheck.getServerVersion());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Unable to check the version with the server.");
        }
        this.reconnectSemaphore.release();
        if (this.reconnectionTask != null) {
            try {
                this.reconnectionTask.run();
                return true;
            }
            catch (Exception e) {
                OrderMate.LOG.error("Unable to do reconnection task", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public ServerConnectionManagerI.ServerConnectionStatus tryConnect() {
        ServerConnectionManagerI.ServerConnectionStatus result = ServerConnectionManagerI.ServerConnectionStatus.NetworkError;
        for (String server : this.servers) {
            this.setAddress(server);
            try {
                if (Terminal.isLocalHostSetup()) {
                    Terminal.setupServerMate(this.currentServer);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot set the current Server", (Throwable)ex);
            }
            result = this.doConnectToServer();
            OrderMate.LOG.info("Connect to server:" + server + " result :" + (Object)((Object)result));
            if (!ServerConnectionManagerI.ServerConnectionStatus.ConnectionSuccess.equals((Object)result) && !ServerConnectionManagerI.ServerConnectionStatus.NoTerminal.equals((Object)result)) continue;
            failedConnectionCount = 0L;
            OrderMate.LOG.info("Hooked onto Server:" + this.currentServer);
            try {
                Terminal.setupServerMate(this.currentServer);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot set the secondary server to Terminal.", (Throwable)ex);
            }
            this.secondaryServer = !this.currentServer.equals(this.servers.get(0));
            try {
                if (TimeClient.getInstance() != null) {
                    TimeClient.getInstance().connect();
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.info("Could not reconfigure the TimeClient instance");
            }
            return result;
        }
        return result;
    }

    public boolean isSecondaryServer() {
        return this.secondaryServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerConnectionManagerI.ServerConnectionStatus doConnectToServer() {
        ServerConnectionManagerI.ServerConnectionStatus result = ServerConnectionManagerI.ServerConnectionStatus.NetworkError;
        try {
            OrderMate.LOG.info("Attempting to connect to : " + this.currentServer);
            InetAddress server = InetAddress.getByName(this.currentServer);
            try {
                if (Config.isConfigSetup() && Config.getBooleanValue("skip_is_reachable")) {
                    server.isReachable(500);
                }
            }
            catch (NoSuchMethodError e) {
                Socket httpSocket = new Socket(server, 80);
                httpSocket.close();
            }
            result = ServerConnectionManagerI.ServerConnectionStatus.NoServermate;
            ConnectionChecker.check(this);
            ServerConnectionManager e = this;
            synchronized (e) {
                OrderMate.LOG.info("Connecting up Remote Persistence");
                result = this.setupRemotePersistence(server);
            }
        }
        catch (Throwable e) {
            this.logError(e);
        }
        return result;
    }

    private void logError(Throwable e) {
        if (++failedConnectionCount % 100L == 0L) {
            OrderMate.LOG.info("Error trying to connect to server", e);
        }
    }

    private ServerConnectionManagerI.ServerConnectionStatus setupRemotePersistence(final InetAddress server) throws Exception {
        RemotePersistence rp;
        ServerConnectionManagerI.ServerConnectionStatus result = ServerConnectionManagerI.ServerConnectionStatus.NoServermate;
        if (!PersistenceManager.isPersistenceSetup() || !PersistenceManager.getPersistenceDelegate().equals(this.persistenceDelegate)) {
            if (PersistenceManager.isPersistenceSetup()) {
                OrderMate.LOG.warn("Reinitializing persistence in ServerConnectionManager.tryConnect()");
            }
            rp = new RemotePersistence(this);
            this.persistenceDelegate = LPAPersistenceDelegate.createInstance(new UnsafePersistenceWrapper(rp, UnsafePersistenceWrapper.LOG_AND_THROW));
            PersistenceManager.initialize(this.persistenceDelegate);
            this.persistenceDelegate.registerMappings(AllMappings.getMappings());
        } else {
            UnsafePersistenceWrapper wrapper = (UnsafePersistenceWrapper)this.persistenceDelegate.getPersistence();
            UnsafePersistence wrappedPersistence = wrapper.getWrappedPersistence();
            while (wrappedPersistence instanceof PersistenceWrapper) {
                wrappedPersistence = ((PersistenceWrapper)((Object)wrappedPersistence)).getWrappedPersistence();
            }
            if (wrappedPersistence instanceof RemotePersistence) {
                rp = (RemotePersistence)wrappedPersistence;
            } else {
                throw new IllegalStateException("Using server connection manager but no access to remote persistence.");
            }
        }
        RMIPersistenceRetriever factory = new RMIPersistenceRetriever(){

            @Override
            public RMIPersistenceLayer retrievePersistence() throws RemoteException, NotBoundException {
                OrderMate.LOG.info("Creating new Remote Persistence");
                return (RMIPersistenceLayer)SimpleRMI.getObject(server, "RMIStore", 11100);
            }
        };
        rp.setRemoteFactory(factory);
        new SetupMeasureUnitTask().run();
        this.setupDatabaseService(server);
        if (rp.ping() == null) {
            throw new RemoteException("Ping failed to connect to Persistence.");
        }
        try {
            Price.setDollarSign(Internationalization.getLiteralFor("DOLLAR_SIGN"));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot set localised dollar sign", (Throwable)ex);
        }
        InetAddress inetAddress = InetAddress.getLocalHost();
        List<InetAddress> localAddresses = IPAddressUtils.getLocalAddresses();
        OrderMate.LOG.info("My Addresses:" + Arrays.toString(localAddresses.toArray()));
        for (InetAddress nextIp : localAddresses) {
            if (this.localTerminalType != null) {
                String sql = "SELECT COUNT(*) FROM config_terminal WHERE config_terminal.IPAddress = ? AND config_terminal.type = ?";
                PersistenceManager.getInstance();
                Object[][] terminalResult = PersistenceManager.getPersistenceDelegate().executeQuery(sql, new String[]{nextIp.getHostAddress(), this.localTerminalType});
                if (terminalResult != null && terminalResult.length > 0 && terminalResult[0].length > 0) {
                    int count = Integer.valueOf(String.valueOf(terminalResult[0][0]));
                    if (count == 0) {
                        result = ServerConnectionManagerI.ServerConnectionStatus.NoTerminal;
                        continue;
                    }
                    DocketProcessor.connect(server, 11100);
                    result = ServerConnectionManagerI.ServerConnectionStatus.ConnectionSuccess;
                    inetAddress = nextIp;
                    break;
                }
                result = ServerConnectionManagerI.ServerConnectionStatus.NoTerminal;
                continue;
            }
            result = ServerConnectionManagerI.ServerConnectionStatus.ConnectionSuccess;
            inetAddress = nextIp;
            break;
        }
        if (!this.registerRemoteCache.get()) {
            return result;
        }
        final InetAddress terminalInetAddress = inetAddress;
        new Thread(new Runnable(){

            @Override
            public void run() {
                int count = 0;
                while (count < 5) {
                    try {
                        CacheManager.getInstance().subscribeToRemoteCache(terminalInetAddress, server);
                        OrderMate.LOG.info("Successfully subscribed to remote cache on " + server + " from " + terminalInetAddress);
                        count = 6;
                    }
                    catch (Exception ex) {
                        ++count;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (count != 5) continue;
                        OrderMate.LOG.error("Could not subscribe to remote cache on reconnection after 5 attempts.  Remote Cache on :" + terminalInetAddress, (Throwable)ex);
                    }
                }
            }
        }).start();
        return result;
    }

    private void setupDatabaseService(InetAddress server) throws RemoteException, NotBoundException {
        DataService dbs1 = (DataService)SimpleRMI.getObject(server, "DatabaseService", 11100);
        DatabaseMaintenanceService maintenance = (DatabaseMaintenanceService)SimpleRMI.getObject(server, "DatabaseMaintenanceService", 11100);
        Data.setDBMaintenanceService(maintenance);
        Data.setup(dbs1, this);
        if (Data.database.getAbout() == null) {
            throw new RemoteException("Database connection test has failed");
        }
    }

    public synchronized void setAddress(String newAddress) {
        this.currentServer = newAddress;
    }

    public synchronized String getAddress() {
        return this.currentServer;
    }

    public void setRegisterRemoteCache(boolean registerRemoteCache) {
        this.registerRemoteCache.set(registerRemoteCache);
    }

    public boolean getRegisterRemoteCache() {
        return this.registerRemoteCache.get();
    }

    @Override
    public void waitUntilConnected() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doReconnectWork(false);
        } else if (Thread.currentThread().equals(ConnectionCheckThread.getInstance().getRunningThread())) {
            OrderMate.LOG.warn("Reconnection thread entered waitUntilConnected(), problems with reconnection");
            this.doReconnectWork(false);
        } else {
            this.connected.waitUntilTrue();
        }
    }

    public static ServerConnectionManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Must call ServerConnectionManager.setupInstance() before calling getInstance");
        }
        return instance;
    }

    public static boolean isSetup() {
        return instance != null;
    }

    public static boolean isConnected() {
        return ServerConnectionManager.instance.reconnectCount < 0;
    }

    public static ServerConnectionManager setupInstance(List<String> newSecondaryServers, ConnectionManagerScreen screen, String terminalType, Runnable reconnectionTask) {
        if (instance != null) {
            throw new IllegalStateException("ServerConnectionManager has already been setup");
        }
        instance = new ServerConnectionManager(newSecondaryServers, screen, terminalType, reconnectionTask);
        return instance;
    }

    static {
        reconnectSignal = Signals.createSignal();
        failedConnectionCount = 0L;
    }
}

