/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection.updatemate;

import au.com.ordermate.simplermi.SimpleRMI;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.serverconnection.updatemate.UpdateMateService;

public class UpdateMateServiceClient {
    public static final String HAPPY = "happy";
    public static final String CONFUSED = "confused";
    public static final String ANGRY = "angry";
    private static UpdateMateService service = null;

    private UpdateMateServiceClient() {
    }

    public static void connect() throws RemoteException {
        String address = Terminal.getServerMateTerminal().getIPAddress();
        if (address == null || address.trim().length() == 0) {
            throw new RemoteException("Cannot connect to the UpdateMateService on Servermate, bad IP.");
        }
        try {
            InetAddress serverIp = InetAddress.getByName(address);
            service = (UpdateMateService)SimpleRMI.getObject(serverIp, "Update Mate", 11100);
        }
        catch (UnknownHostException e) {
            OrderMate.LOG.error((Object)e);
            throw new RemoteException("Cannot access server properties: the server " + address + " is Unknow");
        }
        catch (NotBoundException e) {
            OrderMate.LOG.error((Object)e);
            throw new RemoteException("Cannot access server properties: PropertiesServer object not bound to " + address);
        }
    }

    public static boolean isAvailable() {
        if (service == null) {
            try {
                UpdateMateServiceClient.connect();
                return service.isAvailable();
            }
            catch (RemoteException ex) {
                OrderMate.LOG.info((Object)ex);
                return false;
            }
        }
        try {
            return service.isAvailable();
        }
        catch (RemoteException ex) {
            OrderMate.LOG.info((Object)ex);
            return false;
        }
    }

    public static boolean updateMood(String mood, String user, String comment) {
        if (UpdateMateServiceClient.isAvailable()) {
            try {
                return service.updateMood(mood, user, comment);
            }
            catch (RemoteException ex) {
                OrderMate.LOG.warn("Could not contact updatemate to update mood to " + mood, (Throwable)ex);
            }
        }
        return false;
    }

    public static String getCurrentMood() {
        if (UpdateMateServiceClient.isAvailable()) {
            try {
                return service.getCurrentMood();
            }
            catch (RemoteException ex) {
                OrderMate.LOG.warn("Could not contact update mate to get current mood", (Throwable)ex);
            }
        }
        return null;
    }
}

