/*
 * Decompiled with CFR 0.152.
 */
package ordermate.serverconnection.updatemate;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import ordermate.OrderMate;
import ordermate.serverconnection.updatemate.UpdateMateService;
import updatemate.client.ClientUpdateWSClient;
import updatemate.client.HappyCustomerWSClient;
import updatemate.client.service.ServiceUnavailableException;

public class UpdateMateServiceImpl
extends UnicastRemoteObject
implements UpdateMateService {
    private final ClientUpdateWSClient updateMateClient;
    private HappyCustomerWSClient happyCustomerClient = null;

    public UpdateMateServiceImpl(ClientUpdateWSClient updateMateClient) throws RemoteException {
        this.updateMateClient = updateMateClient;
    }

    @Override
    public boolean updateMood(String mood, String user, String comment) throws RemoteException {
        if (this.isAvailable()) {
            try {
                this.happyCustomerClient.updateMood(mood, user, comment);
            }
            catch (ServiceUnavailableException ex) {
                OrderMate.LOG.info("Cannot get the current mood.", (Throwable)ex);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentMood() throws RemoteException {
        if (this.isAvailable()) {
            try {
                return this.happyCustomerClient.getCurrentMood();
            }
            catch (ServiceUnavailableException ex) {
                OrderMate.LOG.info("Cannot get the current mood.", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public boolean isAvailable() throws RemoteException {
        if (this.happyCustomerClient != null) {
            return true;
        }
        Long siteId = this.updateMateClient.getSiteId();
        if (siteId != null) {
            OrderMate.LOG.info("Got the updatemate site Id " + siteId);
            this.happyCustomerClient = new HappyCustomerWSClient(siteId);
            return true;
        }
        OrderMate.LOG.info("Could not retrieve the site Id from UpdateMate.");
        return false;
    }
}

