/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.backup;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.ProcessUtil;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.file.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import ordermate.OrderMate;
import ordermate.database.config.ConfigBackup;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemCurrentInfo;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class BackupProcess {
    private static final String BACKUP_DIR = "Backup";
    private static final String IF_EXIST = "IF EXIST ";
    private String backupDir;
    private String copyDir;
    private String batchFileName;
    private String copyDirName;
    private String sevenZName;
    private String zipName;
    private String result;
    private StringBuilder batchBuilder;
    private final ConfigBackup config;

    public BackupProcess(ConfigBackup yourBackup) {
        this.config = yourBackup;
        this.reset();
    }

    public boolean run() {
        this.reset();
        this.checkDiskSpace();
        boolean allGood = this.preVerify();
        allGood = allGood && this.doCopy();
        allGood = allGood && this.doCompress();
        boolean bl = allGood = allGood && this.postVerify();
        if (allGood) {
            this.config.setLastSuccess(new Date());
        }
        allGood = allGood && this.copyLocal();
        allGood &= this.copyLan();
        allGood &= this.copyRemote();
        if (!(allGood &= this.cleanUp())) {
            this.config.setLastError(new Date());
        }
        this.config.setLastResult(this.result);
        return allGood;
    }

    public boolean checkDiskSpace() {
        boolean enoughSpace;
        File backup = new File(this.copyDir);
        long usableSpace = backup.getUsableSpace();
        File db = new File(this.backupDir);
        long requiredSpace = FileUtils.fileSize(db);
        int MEGA = 1000000;
        boolean bl = enoughSpace = (double)usableSpace > (double)requiredSpace * 1.5;
        if (!enoughSpace) {
            this.addResult(ResultType.WARN, "Disk Space low. Want " + requiredSpace / 1000000L + "MB but have " + usableSpace / 1000000L + "MB", null);
            return false;
        }
        this.addResult(ResultType.INFO, "Disk space good. Want " + requiredSpace / 1000000L + "MB and have " + usableSpace / 1000000L + "MB", null);
        return true;
    }

    public boolean preVerify() {
        Object[][] values = PersistenceManager.getPersistenceDelegate().executeQuery("SHOW TABLES", new Object[0]);
        boolean allGood = true;
        for (Object[] nextRow : values) {
            Object[][] response = PersistenceManager.getPersistenceDelegate().executeQuery("CHECK TABLE " + String.valueOf(nextRow[0]) + " MEDIUM ", new Object[0]);
            String table = String.valueOf(response[0][0]);
            String type = String.valueOf(response[0][2]);
            String text = String.valueOf(response[0][3]);
            if ("error".equals(type)) {
                allGood = false;
                this.addResult(ResultType.ERROR, "Bad table: " + table + " - " + text, null);
                continue;
            }
            if (!"warning".equals(type)) continue;
            this.addResult(ResultType.WARN, "Warning : " + table + " - " + text, null);
        }
        if (allGood) {
            this.addResult(ResultType.INFO, "Preverification all good", null);
        }
        return allGood;
    }

    public boolean doCopy() {
        this.batchBuilder = new StringBuilder();
        this.line("REM Delete the previous backup");
        this.line(IF_EXIST + this.copyDirName + " DEL /s /q " + this.copyDirName);
        this.line("");
        this.line("REM make a copy of the ordermate prod directory to the directory of the relevant day");
        this.line("xcopy /s /y /z " + this.backupDir + " " + this.copyDirName + "\\");
        this.line("");
        return this.makeAndRun("Copy");
    }

    public boolean doCompress() {
        this.batchBuilder = new StringBuilder();
        File compExe = new File("C:\\Program Files (x86)\\ordermate\\7za.exe");
        if (!compExe.exists() && !(compExe = new File("C:\\Program Files\\ordermate\\7za.exe")).exists()) {
            compExe = new File("C:\\temp\\ordermate\\7za.exe");
        }
        this.line("REM compress the backup so that it can be easily downloaded");
        this.line(IF_EXIST + this.copyDir + this.zipName + " DEL /s /q " + this.zipName);
        this.line(IF_EXIST + this.copyDir + this.sevenZName + " DEL /s /q " + this.sevenZName);
        this.line("");
        this.line("\"" + compExe.getPath() + "\" a -tzip " + this.copyDirName + " " + this.copyDirName);
        this.line("\"" + compExe.getPath() + "\" a " + this.copyDirName + " " + this.copyDirName);
        this.line("");
        return this.makeAndRun("Compress");
    }

    public boolean postVerify() {
        File zipFile = new File(this.copyDir + this.zipName);
        File sevenZFile = new File(this.copyDir + this.sevenZName);
        boolean allGood = this.checkFile(zipFile) && this.checkFile(sevenZFile);
        return allGood;
    }

    private boolean checkFile(File value) {
        if (!value.exists()) {
            this.addResult(ResultType.ERROR, value.getName() + " backup file not created!", null);
            return false;
        }
        if (value.length() < 100000L) {
            this.addResult(ResultType.ERROR, value.getName() + " backup file not large enough", null);
            return false;
        }
        this.addResult(ResultType.INFO, value.getName() + " is valid", null);
        return true;
    }

    public boolean copyLocal() {
        this.batchBuilder = new StringBuilder();
        this.line("@echo on");
        String localDir = this.config.getLocalLoc();
        if (StringUtils.isEmpty(localDir)) {
            this.addResult(ResultType.INFO, "Not copying to local", null);
            return true;
        }
        File file = new File(localDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.line(IF_EXIST + localDir + this.zipName + " DEL /s /q " + localDir + this.zipName);
        this.line(IF_EXIST + localDir + this.sevenZName + " DEL /s /q " + localDir + this.sevenZName);
        this.line("copy /y " + this.copyDirName + ".zip " + localDir + this.zipName);
        this.line("copy /y " + this.copyDirName + ".7z " + localDir + this.sevenZName);
        this.line("");
        return this.makeAndRun("Copy Local");
    }

    public boolean copyLan() {
        if (StringUtils.isEmpty(this.config.getLanLoc()) || StringUtils.isEmpty(this.config.getLanUser())) {
            this.addResult(ResultType.INFO, "Lan backup is not configured", null);
            return true;
        }
        String dir = "Backup\\";
        this.batchBuilder = new StringBuilder();
        this.line("REM using net use, make a copy of the backup to wmt1");
        this.line("net use r: " + this.config.getLanLoc() + " /USER:" + this.config.getLanUser() + " " + this.config.getLanPass());
        File lan = new File(this.config.getLanLoc() + "\\" + dir);
        if (!lan.exists()) {
            lan.mkdirs();
        }
        this.line("IF EXIST r:\\" + dir + this.zipName + " DEL /f /s /q r:\\" + dir + this.zipName);
        this.line("copy /y /z " + this.copyDir + this.zipName + " r:\\" + dir + this.zipName);
        return this.makeAndRun("Copy Lan");
    }

    public boolean copyRemote() {
        if (StringUtils.isEmpty(this.config.getRemoteLoc()) || StringUtils.isEmpty(this.config.getRemoteUser())) {
            this.addResult(ResultType.INFO, "Remote backup is not configured", null);
            return true;
        }
        String user = this.config.getRemoteUser();
        String pass = this.config.getRemotePass();
        try {
            FTPSClient ftp;
            String hostname = this.config.getRemoteLoc();
            if (hostname.toLowerCase().startsWith("ftps://")) {
                hostname = hostname.replace("ftps://", "");
                ftp = new FTPSClient();
            } else {
                hostname = hostname.replace("ftp://", "");
                ftp = new FTPClient();
            }
            ftp.connect(hostname);
            ftp.setSoTimeout(600000);
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                this.addResult(ResultType.ERROR, "Remote back failed - cannot connect", null);
                return false;
            }
            ftp.enterLocalPassiveMode();
            if (!ftp.login(user, pass)) {
                this.addResult(ResultType.ERROR, "Remote backup copy failed - cannot login", null);
                return false;
            }
            String remoteDir = "/Backup/";
            if (!ftp.changeWorkingDirectory(remoteDir)) {
                this.addResult(ResultType.ERROR, "Remote backup copy failed - cannot change to directory " + remoteDir, null);
                return false;
            }
            String remoteFileName = this.getRemoteFilename();
            ftp.deleteFile(remoteDir + remoteFileName);
            FileInputStream fis = new FileInputStream(this.copyDir + this.sevenZName);
            ftp.setFileType(2);
            if (!ftp.storeFile(remoteFileName, (InputStream)fis)) {
                this.addResult(ResultType.INFO, "Remote backup failed:" + remoteFileName, null);
            }
            fis.close();
            ftp.logout();
            this.addResult(ResultType.INFO, "Remote backup succeeded:" + remoteFileName, null);
        }
        catch (IOException ex) {
            this.addResult(ResultType.ERROR, "Remote Backup Copy has an error", ex);
            return false;
        }
        catch (NoSuchAlgorithmException ex) {
            this.addResult(ResultType.ERROR, "Unable to use FTPS", ex);
            return false;
        }
        return true;
    }

    public boolean cleanUp() {
        this.batchBuilder = new StringBuilder();
        this.line("REM cleaning up the copied db");
        this.line(IF_EXIST + this.copyDirName + " rmdir /s /q " + this.copyDirName);
        this.line("");
        return this.makeAndRun("Cleanup");
    }

    protected String getRemoteFilename() {
        String mark = "Daily";
        Date marker = this.config.getMarkerDate();
        long DAY = 86400000L;
        if (marker != null) {
            long time = System.currentTimeMillis() - marker.getTime();
            if (time >= 2592000000L) {
                this.config.setMarkerDate(new Date());
                mark = "Monthly";
            } else if (time / 86400000L % 7L == 0L) {
                mark = "Weekly";
            }
        } else {
            this.config.setMarkerDate(new Date());
        }
        BusinessInfo info = BusinessInfo.getInstance();
        return SystemCurrentInfo.getInstance().getRedbackId() + " " + info.getName() + " - " + info.getLocation() + " " + mark + ".7z";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeAndRun(String process) {
        File batchFile = new File(this.batchFileName);
        if (!batchFile.getParentFile().exists()) {
            batchFile.getParentFile().mkdirs();
        }
        if (batchFile.exists()) {
            batchFile.delete();
        }
        boolean written = false;
        FileWriter writer = null;
        try {
            writer = new FileWriter(batchFile);
            writer.write(this.batchBuilder.toString());
            writer.flush();
            written = true;
        }
        catch (Exception ex) {
            this.addResult(ResultType.ERROR, "Couldn't create backup batch file", ex);
            OrderMate.LOG.error("Cannot write to backup batch file", (Throwable)ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Can't even close it off", (Throwable)ex);
                }
            }
        }
        boolean outcome = false;
        if (written) {
            try {
                int result = ProcessUtil.runCmdAndWait(batchFile.toString());
                outcome = result == 0;
            }
            catch (Exception ex) {
                this.addResult(ResultType.ERROR, "Problem running the backup batch file", ex);
            }
            finally {
                batchFile.delete();
            }
        }
        if (!outcome) {
            this.addResult(ResultType.ERROR, "Problem with " + process, null);
        } else {
            this.addResult(ResultType.INFO, process + " all good", null);
        }
        return outcome;
    }

    private void line(String value) {
        this.batchBuilder.append(value).append("\r\n");
    }

    public String getResult() {
        return this.result;
    }

    public void reset() {
        this.batchBuilder = null;
        this.result = null;
        this.backupDir = this.config.getBackupDir();
        this.copyDir = this.config.getCopyDir();
        this.batchFileName = this.config.getBatchFile();
        String copyName = Calendar.getInstance().getDisplayName(7, 2, Locale.getDefault());
        this.copyDirName = this.copyDir + copyName;
        this.sevenZName = copyName + ".7z";
        this.zipName = copyName + ".zip";
    }

    private void addResult(ResultType type, String string, Exception ex) {
        this.result = this.result == null ? type.prefix + " " + string : this.result + "\r\n" + type.prefix + " " + string;
        if (ex != null) {
            OrderMate.LOG.error(string, (Throwable)ex);
        } else {
            OrderMate.LOG.info(string);
        }
    }

    private static enum ResultType {
        INFO("(/)"),
        WARN("(!)"),
        ERROR("(X)");

        private final String prefix;

        private ResultType(String pref) {
            this.prefix = pref;
        }

        String getPrefix() {
            return this.prefix;
        }
    }
}

