/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.finance;

import au.com.ordermate.persistence.Executable;
import ordermate.database.finance.Shift;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;

public class CreateShiftExecutable
extends Executable<Shift> {
    private final TradingDay tradingDay;
    private final ConfigShift shift;

    public CreateShiftExecutable(TradingDay tradingDay, ConfigShift shift) {
        if (tradingDay == null || shift == null) {
            throw new IllegalArgumentException("Change of shift cannot occur if the given trading day or shift are null!");
        }
        this.tradingDay = tradingDay;
        this.shift = shift;
    }

    @Override
    public Shift execute() {
        return Shift.createShift(this.tradingDay, this.shift);
    }
}

