/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.finance.debtors;

import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.services.finance.debtors.DebtorDateFilterStrategy;
import ordermate.services.finance.debtors.DebtorSalesFilter;

public class StatusDebtorSalesFilter
implements DebtorSalesFilter {
    private String paymentStatus = "DEFAULT";
    public static final String STATUS_DEFAULT = "DEFAULT";
    public static final String STATUS_PAID = "PAID";
    public static final String STATUS_OUTSTANDING = "OUTSTANDING";
    public static final String STATUS_OVERDUE = "OVERDUE";
    public static final String STATUS_ALL = "ALL";
    private Date startDate;
    private Date endDate;
    private DebtorDateFilterStrategy filterStrategy;
    private List invoiceNumbers = new ArrayList();

    public void setPaymentStatus(String status) {
        this.paymentStatus = status;
    }

    public void setDate(Date date) {
        this.startDate = date;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public void setDateFilterStrategy(DebtorDateFilterStrategy strategy) {
        this.filterStrategy = strategy;
    }

    public void setInvoiceNumbers(List numbers) {
        this.invoiceNumbers = numbers;
    }

    @Override
    public List<DebtorSale> applyFilter(List<DebtorSale> debtorSales) {
        ArrayList<DebtorSale> filteredList = new ArrayList<DebtorSale>();
        for (DebtorSale sale : debtorSales) {
            if (!this.checkFilter(sale)) continue;
            filteredList.add(sale);
        }
        return filteredList;
    }

    private boolean checkDateFilter(DebtorSale sale) {
        Date invDate = sale.getSaleDate();
        Date paidDate = sale.getPaidDate();
        if (paidDate != null) {
            paidDate = DateTimeUtils.clearTimePart(paidDate);
        }
        if (invDate != null) {
            invDate = DateTimeUtils.clearTimePart(invDate);
        }
        if (this.filterStrategy == null) {
            return true;
        }
        return DebtorDateFilterStrategy.InvoiceDate.equals((Object)this.filterStrategy) ? !(this.startDate == null || invDate == null || !invDate.after(this.startDate) && !invDate.equals(this.startDate) || this.endDate == null || !invDate.before(this.endDate) && !invDate.equals(this.endDate)) : (DebtorDateFilterStrategy.PaidDate.equals((Object)this.filterStrategy) ? !(this.startDate == null || paidDate == null || !paidDate.after(this.startDate) && !paidDate.equals(this.startDate) || this.endDate == null || !paidDate.before(this.endDate) && !paidDate.equals(this.endDate)) : !(!DebtorDateFilterStrategy.PaidAndInvoiceDate.equals((Object)this.filterStrategy) || this.startDate == null || paidDate == null || invDate == null || !paidDate.after(this.startDate) && !paidDate.equals(this.startDate) || !invDate.after(this.startDate) && !invDate.equals(this.startDate) || this.endDate == null || !paidDate.before(this.endDate) && !paidDate.equals(this.endDate) || !invDate.before(this.endDate) && !invDate.equals(this.endDate)));
    }

    private boolean checkInvoiceNumbers(DebtorSale sale) {
        return this.invoiceNumbers.contains(new Integer(sale.getInvoiceNumber()));
    }

    private boolean checkFilter(DebtorSale sale) {
        if (this.paymentStatus != null && !this.paymentStatus.equalsIgnoreCase(STATUS_ALL) && (this.paymentStatus.equalsIgnoreCase(STATUS_OUTSTANDING) ? sale.isPaid() : (this.paymentStatus.equalsIgnoreCase(STATUS_OVERDUE) ? !sale.isOverdue() : this.paymentStatus.equalsIgnoreCase(STATUS_PAID) && !sale.isPaid()))) {
            return false;
        }
        if (!this.checkDateFilter(sale)) {
            return false;
        }
        return this.invoiceNumbers.isEmpty() || this.checkInvoiceNumbers(sale);
    }
}

