/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.finance.tradingday;

import au.com.ordermate.networkio.ExecuteTaskAsLocalService;
import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import ordermate.database.hardware.Terminal;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class UpdateTradingDayCallable
implements Callable<String> {
    private Terminal terminal;

    public UpdateTradingDayCallable(Terminal terminal) {
        this.terminal = terminal;
    }

    @Override
    public String call() {
        String message = null;
        try {
            CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable("waitermate.TradingDayUpdater", "getInstance", "changeTradingDay");
            ExecuteTaskAsLocalService executeTaskAsLocalService = (ExecuteTaskAsLocalService)SimpleRMI.getObject(this.terminal.getAddress(), "ExecuteTaskAsLocalService", this.terminal.getRmiPort());
            executeTaskAsLocalService.executeTask(exec);
            message = this.getSuccessMessage();
        }
        catch (ConnectException e) {
            message = this.getErrorMessage() + "\n Connection refused!";
        }
        catch (NotBoundException e) {
            message = this.getErrorMessage() + "\n Make sure you have the right RMI port or service name in the RMI registry.";
        }
        catch (RemoteException e) {
            message = this.getErrorMessage() + e.getMessage();
        }
        return message;
    }

    public String getTerminalInfo() {
        return this.terminal.getName() + "(" + this.terminal.getAddress() + ")";
    }

    private String getSuccessMessage() {
        return "Successfully updated trading day for Terminal : " + this.getTerminalInfo();
    }

    private String getErrorMessage() {
        return "Could not update trading day for Terminal : " + this.getTerminalInfo();
    }
}

