/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.finance.transactions;

import au.com.ordermate.util.Price;
import ordermate.database.EventContext;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.MOTOTransaction;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;

public class FinanceTransactionFactory {
    public FinanceTransaction createCreditTransaction(EventContext context, Price paid, Price tip, FinanceUnit unit) {
        User user = context.getUser();
        Terminal terminal = context.getTerminal();
        CashDrawer cashdrawer = terminal.getAssignedCashDrawer(user);
        CreditTransaction newTransaction = new CreditTransaction(user, terminal, paid, tip, cashdrawer, unit, terminal.getShift());
        return newTransaction;
    }

    public FinanceTransaction createMOTOTransaction(EventContext context, Price paid, Price tip, FinanceUnit unit) {
        User user = context.getUser();
        Terminal terminal = context.getTerminal();
        CashDrawer cashdrawer = terminal.getAssignedCashDrawer(user);
        MOTOTransaction newTransaction = new MOTOTransaction(user, terminal, paid, tip, cashdrawer, unit, terminal.getShift());
        return newTransaction;
    }

    public FinanceTransaction createDebitTransaction(EventContext context, Price paid, Price tip, Price cashOut, FinanceUnit unit) {
        User user = context.getUser();
        Terminal terminal = context.getTerminal();
        CashDrawer cashdrawer = context.getTerminal().getAssignedCashDrawer(context.getUser());
        DebitTransaction newTransaction = new DebitTransaction(user, terminal, paid, tip, cashOut, cashdrawer, unit, terminal.getShift());
        return newTransaction;
    }

    public WebTransaction createWebTransaction(EventContext context, Price paid, Price tip, FinanceUnit unit) {
        User user = context.getUser();
        Terminal terminal = context.getTerminal();
        CashDrawer cashdrawer = terminal.getAssignedCashDrawer(user);
        WebTransaction newTransaction = new WebTransaction(user, terminal, paid, tip, cashdrawer, unit, terminal.getShift());
        return newTransaction;
    }
}

