/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.hardware.physical.eftpos;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;

public class CashDrawerManager {
    private static CashDrawerManager instance = new CashDrawerManager();
    private final Executor executor = Executors.newSingleThreadExecutor();

    public static CashDrawerManager getInstance() {
        return instance;
    }

    public void openAllCashDrawersNoSale(final User user, final Terminal localHost) {
        if (user == null) {
            String s = "user cannot be null!";
            throw new IllegalArgumentException(s);
        }
        if (!user.hasPermission(AllPermissions.CASHDRAWER)) {
            String s = "user " + user.getID() + " does not have permission to open cashdrawer for no sale!";
            throw new IllegalStateException(s);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (CashDrawer toOpen : localHost.getAvailableCashDrawers(user)) {
                    try {
                        toOpen.open(user);
                        TerminalEventLog.logNoSale(user, localHost, toOpen, null);
                    }
                    catch (Exception e) {
                        OrderMate.LOG.error("Error opening cashdrawer " + toOpen.getLabel(), (Throwable)e);
                    }
                }
            }
        });
    }

    public void openAllCashDrawersSettleDelivery(User user, Terminal localHost) {
        for (CashDrawer toOpen : localHost.getAvailableCashDrawers(user)) {
            try {
                toOpen.open(user);
                TerminalEventLog.logDeliverySettle(user, localHost, toOpen);
            }
            catch (Exception e) {
                OrderMate.LOG.error("Error opening cashdrawer " + toOpen.getLabel(), (Throwable)e);
            }
        }
    }

    public void openAllCashDrawersPayment(final User user, FinanceTransaction transaction, final Terminal localHost) {
        if (transaction == null) {
            String s = "transaction cannot be null!";
            throw new IllegalArgumentException(s);
        }
        if (!transaction.needsOpenCashdrawer()) {
            String s = "transaction cannot open the cashdrawer!";
            throw new IllegalArgumentException(s);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (CashDrawer toOpen : localHost.getAvailableCashDrawers(user)) {
                    try {
                        toOpen.open(user);
                    }
                    catch (Exception e) {
                        OrderMate.LOG.error("Error opening cashdrawer " + toOpen.getLabel(), (Throwable)e);
                    }
                }
            }
        });
    }
}

