/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.hardware.physical.eftpos;

import au.com.ordermate.OrderMateLog;
import ordermate.database.hardware.eftpos.DefaultEftposPrintProcessor;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;

public class EftposPrintProcessorFactory {
    private static Class<? extends EftposPrintProcessor> processorClass = DefaultEftposPrintProcessor.class;
    private static EftposPrintProcessor processor;

    public static final EftposPrintProcessor createEftposPrintProcessor() {
        if (processor != null) {
            return processor;
        }
        EftposPrintProcessor newProcessor = null;
        try {
            newProcessor = processorClass.newInstance();
        }
        catch (InstantiationException ex) {
            OrderMateLog.LOG.error("Couldn't create an EftposPrintProcessor for:" + processorClass, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            OrderMateLog.LOG.error("Couldn't create an EftposPrintProcessor for:" + processorClass, (Throwable)ex);
        }
        return newProcessor;
    }

    private EftposPrintProcessorFactory() {
    }

    public static final void setProcessor(EftposPrintProcessor newProcessor) {
        processor = newProcessor;
    }
}

