/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.messages;

import au.com.ordermate.message.Email;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import javax.mail.internet.InternetAddress;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Customer;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.nudge.NudgeManager;
import ordermate.reports.printing.InvoiceReport;

public class SendDebtorInvoiceEmailExecutable
extends Executable<Boolean> {
    private AbstractDebtor theDebtor;
    private DebtorSale sale;
    private Customer customer;
    private boolean emailSent = false;
    private Thread executionThread;

    public SendDebtorInvoiceEmailExecutable(long debtorSaleId, long customerId) {
        this.sale = PersistenceManager.getByID(debtorSaleId, DebtorSale.class);
        if (this.sale != null) {
            this.theDebtor = this.sale.getDebtor();
        }
        this.customer = PersistenceManager.getByID(customerId, Customer.class);
    }

    @Override
    public Boolean execute() {
        if (this.customer == null) {
            OrderMate.LOG.error("Cannot send invoice without a customer.");
            return Boolean.FALSE;
        }
        if (this.sale == null) {
            OrderMate.LOG.error("Cannot send Debtor Sale Invoice without a DebtorSale. That's just silly.");
            return Boolean.FALSE;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SendDebtorInvoiceEmailExecutable.this.createAndSendReport();
            }
        };
        this.executionThread = new Thread(runnable);
        this.executionThread.start();
        return Boolean.TRUE;
    }

    public void createAndSendReport() {
        File tempFile;
        block9: {
            InvoiceReport report = new InvoiceReport(this.sale.getSaleAccount(), "/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
            tempFile = null;
            try {
                report.generate();
                tempFile = new File(BusinessInfo.getInstance().getName() + " " + this.sale.getSaleAccount().getID() + ".pdf");
                tempFile.deleteOnExit();
                OrderMate.LOG.info("Exporting Debtor PDF to file:" + tempFile);
                JasperExportManager.exportReportToPdfFile((JasperPrint)report.getReport(), (String)tempFile.getAbsolutePath());
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Couldn't output the invoice to a PDF:", (Throwable)ex);
                if (tempFile == null) break block9;
                tempFile.delete();
                return;
            }
        }
        try {
            OrderMate.LOG.info("Emailing Debtor PDF file to email:" + this.customer.getEmail());
            Email email = new Email();
            email.setText("Invoice for Debtor:" + this.theDebtor.getLabel());
            email.addAttachment(tempFile);
            String emailSender = SystemProperty.getInstance().getEmailSender();
            if (!StringUtils.isEmpty(emailSender)) {
                email.addSender(emailSender, emailSender);
            } else {
                email.addSender(new InternetAddress("donotreply@ordermate.com.au"));
            }
            email.addToRecipient(this.customer.getEmail(), this.sale.getDebtor().getLabel());
            email.setSubject(BusinessInfo.getInstance().getName() + " Invoice");
            if (NudgeManager.isNudgeConfigured()) {
                OMOutgoingServiceResponse nudgeResponse = NudgeManager.getInstance().sendEmail(email);
                this.emailSent = nudgeResponse.isSuccessful();
            } else {
                MessageServer server = MessageServer.getServer();
                server.connect();
                server.send(email.createMessage(server.getSession()));
            }
            OrderMate.LOG.info("Debtor PDF file sent");
        }
        catch (Exception e1) {
            OrderMate.LOG.error("Error trying to email debtor statement", (Throwable)e1);
        }
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    public boolean isEmailSent() {
        return this.emailSent;
    }

    public boolean isThreadFinished() {
        return this.executionThread != null && !this.executionThread.isAlive();
    }
}

