/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.messages;

import au.com.ordermate.message.MessageServer;
import au.com.ordermate.message.SMS;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.message.SmsProvider;
import ordermate.database.users.User;

public class SendSmsExecutable
extends Executable<Boolean> {
    private SMS messageContainer;
    private List<String> receivers;
    private String message;
    private MessageServer server;
    private User loggedInUser;
    private int attemptsToConnect = 0;

    public SendSmsExecutable(SMS messageContainer, User user) {
        this.messageContainer = messageContainer;
        this.loggedInUser = user;
        this.attemptsToConnect = 0;
    }

    public SendSmsExecutable(List<String> receivers, String message, User user) {
        this.receivers = receivers;
        this.message = message;
        this.loggedInUser = user;
        this.attemptsToConnect = 0;
    }

    @Override
    public Boolean execute() {
        if (this.getProviderType().equals((Object)SmsProvider.SMSProviderType.Email) && !this.getServer().isSmtpConnected()) {
            OrderMate.LOG.error("Will not send SMS, MessageServer is not connected...");
            return Boolean.FALSE;
        }
        if (this.messageContainer != null) {
            return this.sendSMSObject();
        }
        return this.sendList();
    }

    private MessageServer getServer() {
        if (this.server == null) {
            this.server = MessageServer.getServer();
        }
        if (this.attemptsToConnect == 0 && this.server != null && !this.server.isSmtpConnected()) {
            try {
                this.server.connect();
            }
            finally {
                ++this.attemptsToConnect;
            }
        }
        return this.server;
    }

    private boolean sendSMSObject() {
        if (this.messageContainer == null) {
            OrderMate.LOG.error("The SMS Container is invalid, will not send SMS...");
            return false;
        }
        if (StringUtils.isEmpty(this.getSmsObject().getPhoneNumber())) {
            OrderMate.LOG.error("The Phone number is empty, will not send SMS...");
            return false;
        }
        if (StringUtils.isEmpty(this.getSmsObject().getText())) {
            OrderMate.LOG.error("The message to send is empty, will not send SMS...");
            return false;
        }
        OrderMate.LOG.info("Sending SMS to number '" + this.getSmsObject().getPhoneNumber() + "' - " + this.getSmsObject().getText());
        boolean sent = false;
        sent = this.getProviderType().equals((Object)SmsProvider.SMSProviderType.Email) ? this.getServer().send(this.getSmsObject().createMessage(this.getServer().getSession())) : this.getSmsObject().sendSMSviaHTTP(true);
        if (sent) {
            OrderMate.LOG.info("SMS sent successfully to number '" + this.getSmsObject().getPhoneNumber() + "' - " + this.getSmsObject().getText());
            this.getSmsObject().logSend(this.loggedInUser);
        } else {
            OrderMate.LOG.info("Error while sending SMS to number '" + this.getSmsObject().getPhoneNumber() + "' - " + this.getSmsObject().getText());
        }
        return sent;
    }

    private SmsProvider.SMSProviderType getProviderType() {
        SmsProvider provider = SmsProvider.getProvider();
        return provider.getProviderType();
    }

    private boolean sendList() {
        boolean result = true;
        if (this.message == null || StringUtils.isEmpty(this.message)) {
            OrderMate.LOG.error("The message to send is empty, will not send SMS...");
            return false;
        }
        if (this.receivers != null && !this.receivers.isEmpty()) {
            for (String number : this.receivers) {
                this.getSmsObject().setPhoneNumber(number);
                this.getSmsObject().setText(this.message);
                if (this.sendSMSObject() || !result) continue;
                result = false;
            }
            return result;
        }
        OrderMate.LOG.info("No phone numbers found, not sendind SMS:" + this.message);
        return false;
    }

    private SMS getSmsObject() {
        if (this.messageContainer == null) {
            this.messageContainer = new SMS();
            SmsProvider smsProvider = SmsProvider.getProvider();
            if (smsProvider.getProviderType().equals((Object)SmsProvider.SMSProviderType.Email)) {
                SMS.setup(smsProvider.getEmailSuffix(), smsProvider.getSubject(), smsProvider.getSenderEmail(), smsProvider.getSenderName());
            }
        }
        return this.messageContainer;
    }
}

