/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.misc;

import au.com.ordermate.persistence.Executable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import ordermate.OrderMate;
import ordermate.services.misc.CallMethod;

public class CallMethodOnClassExecutable
extends Executable {
    private final String clazzName;
    private final CallMethod[] calls;

    public CallMethodOnClassExecutable(String clazzNameString, String ... methods) {
        this.clazzName = clazzNameString;
        this.calls = new CallMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            this.calls[i] = new CallMethod(methods[i], new Serializable[0]);
        }
    }

    public CallMethodOnClassExecutable(String clazzNameString, CallMethod ... methods) {
        this.clazzName = clazzNameString;
        CallMethod[] copy = new CallMethod[methods.length];
        System.arraycopy(methods, 0, copy, 0, methods.length);
        this.calls = copy;
    }

    public Object execute() {
        Object value = null;
        try {
            Class<?> clazz = Class.forName(this.clazzName);
            Method method = this.resolveMethod(clazz, this.calls[0]);
            value = method.invoke(null, (Object[])this.calls[0].getParameters());
            for (int i = 1; i < this.calls.length; ++i) {
                method = this.resolveMethod(value.getClass(), this.calls[i]);
                if (method != null) {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                } else {
                    OrderMate.LOG.error("Cannot find method " + this.calls[i] + " on " + value);
                    return null;
                }
                value = method.invoke(value, (Object[])this.calls[i].getParameters());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error while performing reflection " + Arrays.toString(this.calls), (Throwable)ex);
            value = null;
        }
        return value;
    }

    private Method resolveMethod(Class clazz, CallMethod callMethod) throws SecurityException, NoSuchMethodException {
        if (callMethod.getParameters().length == 0) {
            return clazz.getMethod(callMethod.getMethodName(), new Class[0]);
        }
        Method method = this.tryDirect(clazz, callMethod);
        if (method == null) {
            method = this.tryScan(clazz, callMethod);
        }
        return method;
    }

    private Method tryDirect(Class clazz, CallMethod callMethod) {
        try {
            Class[] clazzes = new Class[callMethod.getParameters().length];
            for (int i = 0; i < clazzes.length; ++i) {
                clazzes[i] = callMethod.getParameters()[i].getClass();
            }
            return clazz.getMethod(callMethod.getMethodName(), clazzes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Method tryScan(Class clazz, CallMethod callMethod) {
        Method[] allMethods;
        for (Method nextMethod : allMethods = clazz.getMethods()) {
            if (!callMethod.getMethodName().equals(nextMethod.getName())) continue;
            Class<?>[] params = nextMethod.getParameterTypes();
            Serializable[] callParams = callMethod.getParameters();
            if (params.length != callMethod.getParameters().length) continue;
            boolean good = true;
            for (int i = 0; i < callParams.length; ++i) {
                Class<?> callClazz = callParams[i].getClass();
                if (params[i].isPrimitive()) {
                    if (Long.class.equals(callClazz)) {
                        good = good && Long.TYPE.equals(params[i]);
                        continue;
                    }
                    if (Integer.class.equals(callClazz)) {
                        good = good && Integer.TYPE.equals(params[i]);
                        continue;
                    }
                    if (Boolean.class.equals(callClazz)) {
                        good = good && Boolean.TYPE.equals(params[i]);
                        continue;
                    }
                    throw new IllegalStateException("You need to add your primitive comparison!");
                }
                good = good && (callParams[i] == null || callClazz.isAssignableFrom(params[i]));
            }
            if (!good) continue;
            return nextMethod;
        }
        return null;
    }
}

