/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.misc;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;

public abstract class RetriableTask<T>
implements Callable<T> {
    private Callable<T> task;
    public static final int DEFAULT_NUMBER_OF_RETRIES = 2;
    public static final long DEFAULT_WAIT_TIME = 1000L;
    private int numberOfRetries;
    private long timeToWait;

    public RetriableTask(Callable<T> task) {
        this(2, 1000L, task);
    }

    public RetriableTask(int numberOfRetries, long timeToWait, Callable<T> task) {
        this.numberOfRetries = numberOfRetries;
        this.timeToWait = timeToWait;
        this.task = task;
    }

    @Override
    public T call() throws Exception {
        while (true) {
            try {
                return this.task.call();
            }
            catch (InterruptedException e) {
                throw new Exception(this.getTaskName() + " attempt(s) failed. Task got interrupted.", e);
            }
            catch (CancellationException e) {
                throw new Exception(this.getTaskName() + " attempt(s) failed. Task got cancelled.", e);
            }
            catch (Exception e) {
                --this.numberOfRetries;
                if (this.numberOfRetries <= 0) {
                    throw new Exception(this.getTaskName() + " attempt(s) failed. Max number of retries has been reached.", e);
                }
                Thread.sleep(this.timeToWait);
                continue;
            }
            break;
        }
    }

    public Callable<T> getTaskObject() {
        return this.task;
    }

    public abstract String getTaskName();
}

