/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.reboot;

import au.com.ordermate.persistence.Executable;
import java.io.Serializable;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.reboot.WindowsRebootable;

public class RebootTerminalExecutable
extends Executable
implements Serializable {
    private static final String WHITESPACE = " ";
    private static final int DEFAULT_COUNTDOWN_DELAY = 20;
    private WindowsRebootable myRebootableObject;
    private String myRebootMessage;
    private int myRebootDelay;
    private String myCommand;

    public RebootTerminalExecutable(WindowsRebootable rebootable, String message) {
        this(rebootable, message, 20);
    }

    public RebootTerminalExecutable(WindowsRebootable rebootable, String message, int delay) {
        this.myRebootableObject = rebootable;
        this.myRebootMessage = message;
        this.myRebootDelay = delay;
        this.myCommand = this.getFormattedCommand();
    }

    public Object execute() {
        try {
            return Runtime.getRuntime().exec(this.myCommand);
        }
        catch (Exception ex) {
            OrderMate.LOG.error(this.getErrorMessage(), (Throwable)ex);
            return null;
        }
    }

    private String getErrorMessage() {
        return "The terminal : " + this.myRebootableObject.getRebootableDeviceName() + " failed to reboot.";
    }

    private String getFormattedCommand() {
        StringBuilder builder = new StringBuilder();
        builder.append("cmd.exe").append(WHITESPACE);
        builder.append("/c").append(WHITESPACE);
        builder.append("shutdown").append(WHITESPACE);
        builder.append("-f").append(WHITESPACE);
        builder.append("-r").append(WHITESPACE);
        builder.append("-t").append(WHITESPACE);
        builder.append(this.myRebootDelay).append(WHITESPACE);
        builder.append("-c").append(WHITESPACE);
        builder.append("\"" + this.myRebootMessage + "\"").append(WHITESPACE);
        builder.append("-m \\\\").append(this.myRebootableObject.getRebootableDeviceIPAddress());
        return builder.toString();
    }

    public String getCommand() {
        return this.myCommand;
    }

    public String getRebootableInfo() {
        return this.myRebootableObject.getRebootableDeviceName() + " (" + this.myRebootableObject.getRebootableDeviceIPAddress() + ")";
    }
}

