/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;

public class ItemGroupPriceLevelPolicy {
    private final ItemGroup itemGroup;
    private final Price itemGroupTotal;
    private final String itemGroupLabel;
    private List<SalesItem> itemGroupItems = new ArrayList<SalesItem>();
    private Map<SalesItem, List<SalesComponent>> salesItemsComponents = new HashMap<SalesItem, List<SalesComponent>>();
    private static final ObjectQuery POSSIBLE_PRICE_LEVELS_INV_UNIT = Query.select(PriceLevel.class).distinct().active(PriceLevel.class).linkUsing(UnitPriceLevel.Properties.PRICE_LEVEL).linkUsing(UnitPriceLevel.Properties.UNIT, InventoryItemUnit.Properties.ID);

    public ItemGroupPriceLevelPolicy(ItemGroup theItemGroup) {
        this.itemGroup = theItemGroup;
        this.itemGroupTotal = this.itemGroup.getTotal();
        this.itemGroupLabel = this.itemGroup.getLabel();
        this.cacheSalesItems();
    }

    public Set<PriceLevel> getPossiblePriceLevels(boolean onlyActive, EventContext context) {
        TriggerActivationContext triggerActContext = new TriggerActivationContext(context, new Date(), this.itemGroup);
        List<PriceLevel> allPriceLevels = PriceLevel.getAllPriceLevels();
        int max_price_levels = allPriceLevels.size();
        if (max_price_levels == 1 && this.itemGroupItems.size() > 0 && (!onlyActive || allPriceLevels.get(0).isActive(triggerActContext))) {
            return Collections.singleton(allPriceLevels.get(0));
        }
        HashSet<PriceLevel> pricelevelSet = new HashSet<PriceLevel>();
        HashSet<InventoryItemUnit> invItemUnitSet = new HashSet<InventoryItemUnit>();
        for (SalesItem item : this.itemGroupItems) {
            for (SalesComponent comp : this.salesItemsComponents.get(item)) {
                invItemUnitSet.add(comp.getUnit());
            }
        }
        ObjectQuery query = POSSIBLE_PRICE_LEVELS_INV_UNIT.copy().wherePropertyIn(InventoryItemUnit.Properties.ID, invItemUnitSet);
        pricelevelSet.addAll(PersistenceManager.getObjectList(PriceLevel.class, query.toString(), new Object[0]));
        if (!onlyActive) {
            return pricelevelSet;
        }
        Iterator it = pricelevelSet.iterator();
        while (it.hasNext()) {
            if (((PriceLevel)it.next()).isActive(triggerActContext)) continue;
            it.remove();
        }
        return pricelevelSet;
    }

    public List<SalesItem> usePriceLevel(PriceLevel toUse, boolean ignoreSequence, EventContext context) {
        if (toUse == null) {
            throw new IllegalArgumentException("cannot use null pricelevel");
        }
        Price before = this.itemGroupTotal;
        ArrayList<SalesItem> changedItems = new ArrayList<SalesItem>();
        for (SalesItem currentItem : this.itemGroupItems) {
            if (!this.usePriceLevel(currentItem, toUse, ignoreSequence)) continue;
            changedItems.add(currentItem);
        }
        Price difference = before.subtract(this.itemGroupTotal);
        TerminalEventLog.logForcePriceLevel(context, changedItems.size(), toUse.getLabel(), toUse.isActive(new TriggerActivationContext(context, new Date(), this.itemGroup)), difference, this.itemGroupLabel, this.itemGroup);
        return changedItems;
    }

    private boolean usePriceLevel(SalesItem item, PriceLevel priceLevelToUse, boolean ignoreSequence) {
        boolean changedRetVal = false;
        for (SalesComponent changeComp : this.salesItemsComponents.get(item)) {
            InventoryItemUnit unit;
            UnitPriceLevel unitLevel;
            if (changeComp.getPriceLevel().equals(priceLevelToUse) || !ignoreSequence && priceLevelToUse.getSequence() < changeComp.getPriceLevel().getSequence() || (unitLevel = (unit = changeComp.getUnit()).getUnitPriceLevel(priceLevelToUse)) == null) continue;
            this.setComponentPriceLevel(changeComp, unitLevel);
            changedRetVal = true;
        }
        return changedRetVal;
    }

    public List<SalesItem> useCheapestPriceLevel(boolean increasePrices, EventContext context) {
        ArrayList<SalesItem> changedItems = new ArrayList<SalesItem>();
        TriggerActivationContext triggerActContext = new TriggerActivationContext(context, this.itemGroup.getCreationDateTime(), this.itemGroup);
        Price before = this.itemGroupTotal;
        Iterator<SalesItem> itemIt = this.itemGroupItems.iterator();
        SalesItem splitItem = null;
        while (itemIt.hasNext() || splitItem != null) {
            SalesItem item;
            if (splitItem != null) {
                item = splitItem;
                splitItem = null;
            } else {
                item = itemIt.next();
            }
            for (SalesComponent currentComponent : this.salesItemsComponents.get(item)) {
                if (currentComponent.getUnit().getUnitPriceLevels().size() <= 1) continue;
                UnitPriceLevel cheapest = null;
                SalesQuantity minimumQty = SalesQuantity.ZERO;
                if (!increasePrices) {
                    cheapest = currentComponent.getUnit().getUnitPriceLevel(currentComponent.getPriceLevel());
                }
                for (UnitPriceLevel price : currentComponent.getUnit().getUnitPriceLevels()) {
                    int qty;
                    if (cheapest != null && !(price.getPrice().doubleValue() < cheapest.getPrice().doubleValue()) || (qty = price.getPriceLevel().getQuantityAllowed(triggerActContext)) <= 0) continue;
                    cheapest = price;
                    minimumQty = SalesQuantity.valueOf(qty).min(item.getQuantity());
                }
                if (cheapest == null || cheapest.getPriceLevel().equals(currentComponent.getPriceLevel())) continue;
                if (minimumQty.notEquals(item.getQuantity())) {
                    splitItem = (SalesItem)item.split(item.getQuantity().subtract(minimumQty), context);
                    this.salesItemsComponents.put(splitItem, splitItem.getComponentList());
                }
                this.setComponentPriceLevel(currentComponent, cheapest);
                changedItems.add(item);
            }
        }
        Price difference = before.subtract(this.itemGroupTotal);
        TerminalEventLog.logForceCheapestPriceLevel(context, changedItems.size(), difference, this.itemGroupLabel, this.itemGroup);
        return changedItems;
    }

    public List<SalesItem> useHighestActivePriceLevel(Set priceLevels, boolean ignoreSequence, EventContext context, String reason) {
        HashSet<SalesItem> changedItems = new HashSet<SalesItem>();
        Price before = this.itemGroupTotal;
        Iterator<SalesItem> itemIt = this.itemGroupItems.iterator();
        SalesItem splitItem = null;
        TriggerActivationContext triggerActCtx = new TriggerActivationContext(context, new Date(), this.itemGroup);
        boolean changed = false;
        while (itemIt.hasNext() || splitItem != null) {
            SalesItem salesItem;
            if (splitItem != null) {
                salesItem = splitItem;
                splitItem = null;
            } else {
                salesItem = itemIt.next();
            }
            if (salesItem.getAccount() == null) {
                this.itemGroup.addOrderedItem(salesItem);
                this.salesItemsComponents.put(salesItem, salesItem.getComponentList());
            }
            for (SalesComponent currentComponent : this.salesItemsComponents.get(salesItem)) {
                if (currentComponent.getUnit().getUnitPriceLevels().size() <= 1) continue;
                UnitPriceLevel highestLevel = null;
                SalesQuantity highestQty = SalesQuantity.ZERO;
                if (!ignoreSequence) {
                    highestLevel = currentComponent.getUnit().getUnitPriceLevel(currentComponent.getPriceLevel());
                }
                for (UnitPriceLevel currentUnitPrice : currentComponent.getUnit().getUnitPriceLevels()) {
                    int qty;
                    if (highestLevel != null && currentUnitPrice.getPriceLevel().getSequence() <= highestLevel.getPriceLevel().getSequence() || !priceLevels.contains(currentUnitPrice.getPriceLevel()) || (qty = currentUnitPrice.getPriceLevel().getQuantityAllowed(triggerActCtx)) <= 0) continue;
                    highestLevel = currentUnitPrice;
                    highestQty = salesItem.getQuantity().min(SalesQuantity.valueOf(qty));
                }
                if (highestLevel == null) continue;
                if (!highestLevel.getPriceLevel().equals(currentComponent.getPriceLevel())) {
                    if (highestQty.notEquals(salesItem.getQuantity())) {
                        splitItem = (SalesItem)salesItem.split(salesItem.getQuantity().subtract(highestQty), context);
                        this.salesItemsComponents.put(splitItem, splitItem.getComponentList());
                    }
                    currentComponent.getSalesItem().setComponentPriceLevel(currentComponent, highestLevel);
                    changedItems.add(salesItem);
                    changed = true;
                    continue;
                }
                if (!highestLevel.getPriceLevel().isDefaultLevel() && !this.hasPriceLevelAdjustmentMatch(currentComponent)) {
                    currentComponent.getSalesItem().setComponentPriceLevel(currentComponent, highestLevel);
                    changed = true;
                    continue;
                }
                if (highestLevel.getPriceLevel().isDefaultLevel() && this.hasPriceLevelAdjustmentMatch(currentComponent)) {
                    currentComponent.getSalesItem().setComponentPriceLevel(currentComponent, highestLevel);
                    changed = true;
                    continue;
                }
                if (currentComponent.isPriceEdited() && currentComponent.getBasePrice().equals(currentComponent.getOpenPrice())) {
                    currentComponent.getSalesItem().setComponentPriceLevel(currentComponent, highestLevel);
                    changed = true;
                    continue;
                }
                if (highestLevel.getPriceLevel().isDefaultLevel()) continue;
                currentComponent.getSalesItem().setComponentPriceLevel(currentComponent, highestLevel);
                changed = true;
            }
        }
        if (changed) {
            this.itemGroup.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        }
        Price change = before.subtract(this.itemGroupTotal);
        TerminalEventLog.logUseHighestActivePriceLevel(context, changedItems.size(), change, reason, this.itemGroupLabel, this.itemGroup);
        return new ArrayList<SalesItem>(changedItems);
    }

    private boolean hasPriceLevelAdjustmentMatch(SalesComponent currentComponent) {
        for (SalesPriceAdjustmentUsage usage : currentComponent.getPriceAdjustmentUsages()) {
            if (!PriceAdjustmentType.PRICE_LEVEL.equals(usage.getSalesPriceAdjustment().getType())) continue;
            return true;
        }
        return false;
    }

    public void setComponentPriceLevel(SalesComponent component, UnitPriceLevel level) {
        component.getSalesItem().setComponentPriceLevel(component, level);
        this.itemGroup.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
    }

    private void cacheSalesItems() {
        for (SalesLineItem currentItem : this.itemGroup.getItems()) {
            this.itemGroupItems.addAll(currentItem.getSalesItems());
        }
        for (SalesItem item : this.itemGroupItems) {
            this.salesItemsComponents.put(item, item.getComponentList());
        }
    }
}

