/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.sales;

import au.com.ordermate.persistence.ServiceLocator;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.EventContext;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.SalesRemoveStocked;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.usage.PreProdManager;
import ordermate.database.stock.usage.StockUsage;
import ordermate.database.stock.usage.StockWastage;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.users.User;
import ordermate.services.sales.RemoteSalesComponentUsageService;

public class SalesComponentUsageService
extends UnicastRemoteObject
implements RemoteSalesComponentUsageService {
    private SalesComponent component;
    private SalesQuantity componentQty;
    private User user;
    private String reason;
    private String reasonSuffix;
    private String usage;
    private StockArea decrementArea;
    private boolean retrieveUsages = true;
    private List<StockUsage> createdUsages;

    @Override
    public void useLinkedStock(PersistentObjDescriptor<SalesComponent> theComponent, SalesQuantity compQty, User theUser, String theReason, String theUsage, StockArea theDecrementArea) {
        this.retrieveUsages = false;
        this.useLinkedStock(theComponent.resolveObject(), compQty, theUser, theReason, theUsage, theDecrementArea);
    }

    @Override
    public List<StockUsage> useLinkedStock(SalesComponent salesComponent, SalesQuantity compQty, User theUser, String theReason, String theUsage, StockArea theDecrementArea) {
        this.createdUsages = new ArrayList<StockUsage>();
        this.component = salesComponent;
        this.componentQty = compQty;
        this.user = theUser;
        this.reason = theReason;
        this.usage = theUsage;
        this.decrementArea = theDecrementArea;
        if (this.component != null) {
            this.useLinkedStock();
        } else {
            OrderMate.LOG.warn("Cannot find sales component to process.");
        }
        if (this.retrieveUsages) {
            this.retrieveUsages = true;
            return this.createdUsages;
        }
        this.retrieveUsages = true;
        return null;
    }

    public SalesComponentUsageService() throws RemoteException {
    }

    protected SalesComponentUsageService(SalesComponent component, SalesQuantity componentQty, User user, String reason, String usage, StockArea decrementArea) throws RemoteException {
        this.component = component;
        this.componentQty = componentQty;
        this.user = user;
        this.reason = reason;
        this.usage = usage;
        this.decrementArea = decrementArea;
    }

    public void useLinkedStock() {
        this.useIngredientStock();
        this.useAddStock();
        this.useOptionStock();
    }

    protected void useIngredientStock() {
        Map<StockItem, Quantity> removedStock = this.calcRemovedStock();
        for (StockLink stockLink : this.component.getUnit().getStockInventoryUsageLinks()) {
            this.reasonSuffix = this.buildReasonSuffix(stockLink);
            StockItem stockItem = stockLink.getStockItem();
            Quantity stockQty = stockLink.getQuantity();
            Price stockPrice = null;
            if (this.component.isPersistent() && (this.componentQty.lessThan(0L) || this.usage.equals("WASTED"))) {
                double avgCostPerUnit = this.getAverageUsageCostPerUnitIncTax(this.component, stockItem).doubleValue();
                stockPrice = new Price(this.componentQty.getValue().doubleValue() * avgCostPerUnit * stockQty.getRawValue(), 0.0);
            }
            Quantity usageQty = this.calcUsageQty(stockLink.getQuantity(), stockLink.isFixedQuantity());
            Quantity removedQty = removedStock.get(stockItem);
            Quantity aggregateQty = usageQty;
            if (removedQty != null) {
                aggregateQty = usageQty.subtract(removedQty);
                if (usageQty.abs().lessThan(removedQty.abs())) {
                    removedStock.put(stockItem, removedQty.subtract(usageQty));
                    continue;
                }
                removedStock.remove(stockItem);
            }
            if (aggregateQty.isZero()) continue;
            this.useStock(stockItem, aggregateQty, stockPrice, null);
        }
        if (!removedStock.isEmpty()) {
            String msg = "";
            for (StockItem item : removedStock.keySet()) {
                msg = msg + item + " " + removedStock.get(item) + ", ";
            }
            throw new IllegalStateException("Have stocked minuses that are not matched against \nexisting ingredients :" + msg + "\n" + this);
        }
    }

    private String buildReasonSuffix(StockLink stockLink) {
        String toReturn = null;
        if (this.usage.equals("WASTED") && stockLink instanceof StockInventoryUsageLink) {
            toReturn = " - Wasted via " + ((StockInventoryUsageLink)stockLink).getInventoryItemUnit().getLabel();
        }
        return toReturn;
    }

    @Override
    public String toString() {
        return "SalesComponentUsageHelper [component=" + this.component + ", componentQty=" + this.componentQty + ", user=" + this.user + ", reason=" + this.reason + ", usage=" + this.usage + ", decrementArea=" + this.decrementArea + "]";
    }

    protected void useAddStock() {
        if (this.component.hasPlusses()) {
            for (SalesAdd add : this.component.getCurrentPluses()) {
                for (StockLink stockLink : add.getStockUsage()) {
                    this.useStock(stockLink, null, add.getModificationSize());
                }
            }
        }
    }

    protected void useOptionStock() {
        if (this.component.hasOption()) {
            for (SalesOption option : this.component.getCurrentOptions()) {
                for (StockLink stockLink : option.getStockUsage()) {
                    this.useStock(stockLink, null);
                }
            }
        }
    }

    void checkToAddToUsageList(Long wastageId) {
        if (this.retrieveUsages && wastageId != null) {
            StockWastage wastage = null;
            try {
                wastage = Data.database.getStockWastageByID(wastageId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (wastage != null) {
                this.createdUsages.add(wastage);
            }
        }
    }

    private Quantity useStock(StockLink link, Price stockCostPrice) {
        return this.useStock(link, stockCostPrice, null);
    }

    private Quantity useStock(StockLink link, Price stockPrice, ModificationSize modifier) {
        this.reasonSuffix = this.buildReasonSuffix(link);
        StockItem stockItem = link.getStockItem();
        Quantity stockQty = link.getQuantity();
        Quantity usageQty = this.calcUsageQty(stockQty, link.isFixedQuantity());
        Quantity toReturn = this.useStock(stockItem, usageQty, stockPrice, link.isFixedQuantity() ? null : modifier);
        return toReturn;
    }

    private Quantity useStock(StockItem stockItem, Quantity usageQty, Price stockCostPrice, ModificationSize modifier) {
        if (modifier != null) {
            usageQty = usageQty.multiply(modifier.getMultiplier());
        }
        if (OrderMate.LOG.isDebugEnabled()) {
            OrderMate.LOG.debug("Using stock for area: " + this.decrementArea + "\nQuantity : " + usageQty + "\nStockItem : " + stockItem + "\nSalesComponent : " + this.component);
        }
        Long resultingID = stockItem.useStock(ServiceLocator.locate(PreProdManager.class), this.decrementArea, usageQty, new EventContext(null, this.user), this.component, this.buildReason(), this.usage, stockCostPrice);
        this.checkToAddToUsageList(resultingID);
        if (stockItem.getYieldFactor() != 0.0) {
            double yeildRawValue = usageQty.getRawValue() * stockItem.getYieldFactor();
            Quantity yieldQty = new Quantity(usageQty.getMeasureUnit(), yeildRawValue);
            Long resultingYieldID = stockItem.useStock(null, this.decrementArea, yieldQty, new EventContext(null, this.user), this.component, this.buildReason(), "YIELD", stockCostPrice);
            this.checkToAddToUsageList(resultingYieldID);
        }
        return usageQty;
    }

    private String buildReason() {
        String reasonComplete = null;
        if (this.reason != null) {
            int difference = this.reason.length() + (this.reasonSuffix != null ? this.reasonSuffix.length() : 0) - 100;
            reasonComplete = difference <= 0 ? this.reason + (this.reasonSuffix != null ? this.reasonSuffix : "") : this.reason.substring(0, this.reason.length() - difference) + (this.reasonSuffix != null ? this.reasonSuffix : "");
        }
        return reasonComplete;
    }

    Quantity calcUsageQty(Quantity stockQty, boolean isFixedQty) {
        if (isFixedQty) {
            int unitQuantity = this.componentQty.getValue().compareTo(BigDecimal.ZERO);
            return new Quantity(stockQty.getMeasureUnit(), stockQty.getRawValue() * (double)unitQuantity);
        }
        return new Quantity(stockQty.getMeasureUnit(), this.componentQty.getValue().multiply(BigDecimal.valueOf(stockQty.getRawValue())));
    }

    protected Map<StockItem, Quantity> calcRemovedStock() {
        HashMap<StockItem, Quantity> stockItemQuantities = new HashMap<StockItem, Quantity>();
        List<AbstractSalesRemove> currentMinuses = this.component.getCurrentMinuses();
        ArrayList<SalesRemoveStocked> stocked = new ArrayList<SalesRemoveStocked>(currentMinuses.size());
        for (AbstractSalesRemove remove : currentMinuses) {
            if (!(remove instanceof SalesRemoveStocked)) continue;
            stocked.add((SalesRemoveStocked)remove);
        }
        for (SalesRemoveStocked stockedRemove : stocked) {
            Quantity incrementQty = stockedRemove.getModifiedUsageQty();
            if (incrementQty == null) continue;
            StockItem item = stockedRemove.getStockItem();
            Quantity qtyToAdd = Quantity.ZERO();
            qtyToAdd = stockedRemove.isFixedQty() ? incrementQty : incrementQty.multiply(this.componentQty.getValue().doubleValue());
            Quantity currentQuantity = Quantity.ZERO();
            if (stockItemQuantities.containsKey(item)) {
                currentQuantity = (Quantity)stockItemQuantities.get(item);
            }
            stockItemQuantities.put(item, qtyToAdd.add(currentQuantity));
        }
        return stockItemQuantities;
    }

    private Price getAverageUsageCostPerUnitIncTax(SalesComponent comp, StockItem usedItem) {
        if (StockControlProperty.getInstance().isStockControlEnabled()) {
            try {
                return Data.database.getComponentAverageUsageCostIncTax(comp.intID(), usedItem.intID());
            }
            catch (RemoteException e) {
                Data.handleException(e);
            }
        }
        return null;
    }
}

